//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader;

import org.ariane.tools.*;
import org.ariane.time.Time;
import java.io.Reader;
import javax.swing.text.*;
import javax.swing.text.html.*;

/**
 * ScanSite : a program of the webwader package.
 * <P>
 * This program can be used to generate automatically a site map
 * knowing the URL of the root. It follows recursively all the links
 * present in the documents, skipping those leading outside.
 * The links which are kept are arranged to form a tree which is
 * eventually saved in a plain file and a XML file.
 * <P>
 * These files can be read as the input of other programs of the package.
 
 *
 * @see SiteScanner
 * @see WebSite
 * @version $Id: ScanSite.java,v 3.4 2000/11/09 17:13:51 lefevre Exp $
 * @author  Jean-Paul Le Fvre
 */

class ScanSite extends TryProg {
  /**
   * The url string pointing to the web site.
   */
    private String url;
  /**
   * The name chosen for the site.
   */
    private String sitename = "scanned";
  /**
   * The name chosen for the output file.
   */
    private String filename = null;
  /**
   * @serial The selected scanning order.
   */
private int scan_order = WebNode.BREADTH_FIRST;

//______________________________________________________________________________
  /**
   * Starts the program
   */
public static void main (String args[])
  {

      ToolBox.debug   = true;
      ToolBox.verbose = true;

      ScanSite prog = new ScanSite("ScanSite");

      if (! prog.parseArg(args)) {
	  ToolBox.warn("Can't parse command line");
	  return;
      }
      else if (! prog.run()) {
	  ToolBox.warn("Can't run " + prog.getName());
	  System.exit(ToolBox.WRONG);
      }

      System.exit(ToolBox.OK);
  }
//______________________________________________________________________________
/**
 * Creates the object.
 * @param name the name of the program.
 */
public ScanSite(String name)
  {
    super(name);
  }
//______________________________________________________________________________
/**
 * Installs the specific resources.
 * @see	Resources
 */
protected void setResources()
  {
      resources = Resources.instance();
  }
//______________________________________________________________________________
/**
 * Actually starts the program.
 * <Br>
 * The description of the site is read in an ASCII file.
 * The site is checked.
 * The updated content is saved in a file. (plain and XML)
 */
public	boolean run()
  {
      WebSite site = new WebSite(sitename);

      try {
	  SiteScanner scanner = SiteScanner.instance();

	  ToolBox.warn("Scanning " + url + " in "
                     + WebNode.navigationOrder(scan_order) + " " + new Time());

	  WebNode top = scanner.scan(sitename, url, scan_order);
	  site.setTopNode(top);

	  if(filename == null) filename = sitename + ".site";
	  site.write(filename);

	  if(resources.get(Resources.PREFIX + "XML.Save", ToolBox.hasXML())) {
	      String xmlname = sitename + ".xml";
	      site.writeXML(xmlname);
	  }

	  System.out.println("Done !");
      }
      catch (Exception ex) {
	  try {
	      site.write(filename);
	  }
	  catch (Exception e) {
	      ToolBox.warn("Can't even write file ", e);
	  }
	  ex.printStackTrace();
	  ToolBox.warn("Can't scan " + url, ex);
	  return false;
      }

      return true;
  }
//______________________________________________________________________________
    /**
     * Prints how to use the program.
     */
final private void printUsage()
  {
      System.out.println(
      "Usage   : java org.demo.webwader.ScanSite [options] url");
      System.out.println(
      "Options : [-v|-d|-q][-V][-h][-s sitename][-o filename][-p|-P|-b]");
  }
//______________________________________________________________________________
/**
 * Parses the command line
 * Usage   : [-q|v|d][-V][-h][-s sitename][-o filename][-p|-P|-b] url
 * @param args the command line.
 */
public	boolean parseArg(String args[])
  {
    int i     = 0;
    int error = 0;

    while(i < args.length && args[i].startsWith("-")) {

      String arg = args[i++];
      int j;

      for (j = 1; j < arg.length(); j++) {

	char flag = arg.charAt(j);

	switch (flag) {
	case 'V':
	  VersionInfo.print();
	  break;

	case 'q':
	  ToolBox.verbose = false;
	  ToolBox.debug   = false;
	  break;

	case 'v':
	  ToolBox.verbose = true;
	  ToolBox.debug   = false;
	  break;

	case 'd':
	  ToolBox.verbose = true;
	  ToolBox.debug   = true;
	  break;

	case 's':
	  sitename = args[i++];
	  break;

	case 'o':
	  filename = args[i++];
	  break;

	case 'p':
	  scan_order = WebNode.PREORDER;
	  break;

	case 'P':
	  scan_order = WebNode.POSTORDER;
	  break;

	case 'b':
	  scan_order = WebNode.BREADTH_FIRST;
	  break;

	default	:
	  printUsage();
	  error++;
	  break;
	}
      }
    }

    if(i < args.length)
	url = args[i];
    else
	error++;

    return (error == 0);
  }
//______________________________________________________________________________
}
