//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader;

import org.ariane.tools.ResourcesException;
import org.ariane.tools.ToolBox;

/**
 * A specialized Resources object.
 * <Br>
 *
 * @version $Id: Resources.java,v 3.3 2000/12/05 11:41:02 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */
//______________________________________________________________________________

public	class Resources extends org.ariane.tools.Resources {
    /**
     * @serial The prefix used to fetch properties.
     */
public static final String PREFIX = org.demo.webwader.gui.Traverser.APPLI + ".";

//______________________________________________________________________________
/**
 * Creates the Resources object.
 * <Br>
 * It is derived from the standard ariane resources. The file
 * <Code>webwader.properties</Code> is loaded after the default
 * properties files and before the user's one.
 */
protected Resources()
  {
      super();
      load("webwader.properties");
  }
//______________________________________________________________________________
/**
 * Gets an unique instance of Resources.
 * <Br>
 * It is a singleton.
 * @return the unique instance.
 */
public static org.ariane.tools.Resources instance()
  {
    if(resources == null)
	resources = new Resources();

    return resources;
  }
//______________________________________________________________________________
/**
 * Gets the local URL of the welcome-page.
 * <br>
 * In case of errors return file:/opt/JVS/lib/webwader-welcome.html.
 * @return the location.
 */
public static String getWelcomeLocation()
  {
      String path = instance().getLibDirectory() + "webwader-welcome.html";
      try {
	  return Locator.makeLocator(path).getLocation();
      }
      catch(InvalidLocatorException ex) {
	  ToolBox.warn("Can't create location for " + path, ex);
	  return "file:/opt/JVS/lib/webwader-welcome.html";
      }
  }
//______________________________________________________________________________
}


