//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader;

import org.ariane.tools.*;
import java.io.*;
import java.net.URL;
import java.net.MalformedURLException;
import java.util.*;
import javax.swing.text.*;
import javax.swing.text.html.*;

/**
 * PageParser : a test program of the webwader package.
 * <P>
 * A HTML is parsed, each element is printed.
 *
 * @see SiteScanner#scanPage
 * @version $Id: PageParser.java,v 3.4 2001/01/15 16:36:59 lefevre Exp $
 * @author  Jean-Paul Le Fvre
 */

class PageParser extends TryProg {
  /**
   * @serial The location of the document to parse.
   */
    private String location;

//______________________________________________________________________________
  /**
   * Starts the program
   */
public static void main (String args[])
  {
      PageParser prog = new PageParser("PageParser");

      if (! prog.parseArg(args)) {
	  ToolBox.warn("Can't parse command line");
	  return;
      }
      else if (! prog.run()) {
	  ToolBox.warn("Can't run " + prog.getName());
	  System.exit(ToolBox.OK);
      }
  }
//______________________________________________________________________________
/**
 * Creates the object.
 * @param name the name of the program.
 */
public PageParser(String name)
  {
    super(name);
  }
//______________________________________________________________________________
/**
 * Actually starts the program.
 * <Br>
 */
public	boolean run()
  {
      try {
	  if(ToolBox.verbose) ToolBox.warn("Reading from " + location);

	  Locator locator = Locator.makeLocator(location);
	  String redirect = locator.getRedirectedLocation();
	  if(redirect != null) {
	      locator = Locator.makeLocator(redirect);
	      if(ToolBox.verbose)
		  System.out.println(" redirected : " + locator.toString());
	  }

	  int type = locator.getContentType();

	  if(type == locator.TYPE_NOT_HTML) {
	      System.out.println("Location does not point to a HTML document.");
	      return false;
	  }

	  EditorKit kit   = new HTMLEditorKit();
	  Document doc    = kit.createDefaultDocument();
	  Reader rd       = locator.getReader();
	  doc.putProperty("IgnoreCharsetDirective", Boolean.TRUE);

	  final String FRAMESET = HTML.Tag.FRAMESET.toString();
	  final String FRAME    = HTML.Tag.FRAME.toString();

	  kit.read(rd, doc, 0);

	  System.out.println("Type  : " + type);
	  System.out.println("Title : " +
		(String)doc.getProperty(Document.TitleProperty));

	  ElementIterator it = new ElementIterator(doc);
	  Element elem;
	  int i = 0;
	  /**
	   * Examine each html element found in the document.
	   */
	  while((elem = it.next()) != null) {

	      if(ToolBox.debug)
		  System.out.println("Element " + i++ + " " + elem.getName());

	      AttributeSet set = elem.getAttributes();
	      Enumeration e;

	      if(set == null) {
		  System.out.println("No attributes !");
		  continue;
	      }
	      else if(ToolBox.debug) {
		  for(e = set.getAttributeNames(); e.hasMoreElements();) {
		      System.out.println("\tAttr " + e.nextElement());
		  }
	      }

	      if(elem.getName().equals(FRAMESET)) {
		  System.out.println("Frameset");
		  for(e = set.getAttributeNames(); e.hasMoreElements();) {
		      System.out.println("\tAttr " + e.nextElement());
		  }
	      }

	      if(elem.getName().equals(FRAME)) {
		  System.out.println("Frame");
		  for(e = set.getAttributeNames(); e.hasMoreElements();) {
		      System.out.println("\tAttr " + e.nextElement());
		  }
		  System.out.println("\tSrc " +
				     set.getAttribute(HTML.Attribute.SRC));
	      }

	      AttributeSet s = (AttributeSet)set.getAttribute(HTML.Tag.A);
	      if(s != null) {
		  System.out.println("A");
		  for(e = s.getAttributeNames(); e.hasMoreElements();) {
		      System.out.println("\tAttr " + e.nextElement());
		      System.out.println("\tSrc " +
				     s.getAttribute(HTML.Attribute.HREF));
		  }
	      }
	  }

	  System.out.println("Done ! ");
	  System.exit(ToolBox.OK);
      }
      catch (InvalidLocatorException ex) { 
	ToolBox.warn("Can't locate document", ex);
	return false;
      }
      catch (java.io.IOException ex) {
	  if(ToolBox.debug) ex.printStackTrace();
	  ToolBox.warn("Can't read document", ex);
	  return false;
      }
      catch (Exception ex) {
	  if(ToolBox.debug) ex.printStackTrace();
	  ToolBox.warn("Can't parse document", ex);
	  return false;
      }


      return true;
  }
//______________________________________________________________________________
    /**
     * Prints how to use the program.
     */
final private void printUsage()
  {
      System.out.println(
      "Usage   : java org.demo.webwader.PageParser [options] location");
      System.out.println(
      "Options : [-v|-d|-q][-V][-h]");
  }
//______________________________________________________________________________
/**
 * Parses the command line
 * Usage   : [-q|v|d][-V][-h] location
 * @param args the command line.
 */
public	boolean parseArg(String args[])
  {
    int i     = 0;
    int error = 0;

    while(i < args.length && args[i].startsWith("-")) {

      String arg = args[i++];
      int j;

      for (j = 1; j < arg.length(); j++) {

	char flag = arg.charAt(j);

	switch (flag) {
	case 'V':
	  VersionInfo.print();
	  break;

	case 'q':
	  ToolBox.verbose = false;
	  ToolBox.debug   = false;
	  break;

	case 'v':
	  ToolBox.verbose = true;
	  ToolBox.debug   = false;
	  break;

	case 'd':
	  ToolBox.verbose = true;
	  ToolBox.debug   = true;
	  break;

	default	:
	  printUsage();
	  error++;
	  break;
	}
      }
    }

    if(i < args.length)
	location = args[i];

    return (error == 0);
  }
//______________________________________________________________________________
}
