//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader;

import org.ariane.tools.*;
import java.io.*;
import java.net.*;
import java.util.*;

/**
 * LinkChecker : a test program of the webwader package.
 * <P>
 * A connection to a document is established. The response from
 * the server is printed.
 *
 * @see SiteScanner#scanPage
 * @version $Id: LinkChecker.java,v 3.2 2001/01/15 16:36:59 lefevre Exp $
 * @author  Jean-Paul Le Fvre
 */

class LinkChecker extends TryProg {
  /**
   * @serial The location of the document to check.
   */
    private String link;

//______________________________________________________________________________
  /**
   * Starts the program
   */
public static void main (String args[])
  {
      LinkChecker prog = new LinkChecker("LinkChecker");

      if (! prog.parseArg(args)) {
	  ToolBox.warn("Can't parse command line");
	  return;
      }
      else if (! prog.run()) {
	  ToolBox.warn("Can't run " + prog.getName());
	  System.exit(ToolBox.OK);
      }
  }
//______________________________________________________________________________
/**
 * Creates the object.
 * @param name the name of the program.
 */
public LinkChecker(String name)
  {
    super(name);
  }
//______________________________________________________________________________
/**
 * Actually starts the program.
 */
public	boolean run()
  {
      try {
	  if(ToolBox.verbose) ToolBox.warn("Connecting to " + link);

	  URL url = new URL(link);
	  HttpURLConnection.setFollowRedirects(false);
	  HttpURLConnection c = (HttpURLConnection)url.openConnection();
	  c.setRequestMethod("HEAD");

	  int i = 0;
	  String field;
	  while((field = c.getHeaderField(i)) != null) {
	      String key = c.getHeaderFieldKey(i);
	      if(key == null) {
		 System.out.println(i + " : " + field); 
	      }
	      else {
		  System.out.println(i + " : " + key + " = " + field);
	      }
	      i++;
	  }

      }
      catch (Exception ex) { 
	ToolBox.warn("Can't check document", ex);
	return false;
      }

      return true;
  }
//______________________________________________________________________________
    /**
     * Prints how to use the program.
     */
final private void printUsage()
  {
      System.out.println(
      "Usage   : java org.demo.webwader.LinkChecker [options] link");
      System.out.println(
      "Options : [-v|-d|-q][-V][-h]");
  }
//______________________________________________________________________________
    /**
     * Prints HTTP codes.
     */
final private void printCodes()
  {
      StringBuffer buf = new StringBuffer("HTTP return codes :\n ");

      buf.append("ACCEPTED          : ");
      buf.append(HttpURLConnection.HTTP_ACCEPTED).append("\n ");
      buf.append("BAD_GATEWAY       : ");
      buf.append(HttpURLConnection.HTTP_BAD_GATEWAY).append("\n "); 
      buf.append("BAD_METHOD        : ");
      buf.append(HttpURLConnection.HTTP_BAD_METHOD).append("\n "); 
      buf.append("BAD_REQUEST       : ");
      buf.append(HttpURLConnection.HTTP_BAD_REQUEST).append("\n "); 
      buf.append("CLIENT_TIMEOUT    : ");
      buf.append(HttpURLConnection.HTTP_CLIENT_TIMEOUT).append("\n ");
      buf.append("CONFLICT          : ");
      buf.append(HttpURLConnection.HTTP_CONFLICT).append("\n "); 
      buf.append("CREATED           : ");
      buf.append(HttpURLConnection.HTTP_CREATED).append("\n ");
      buf.append("ENTITY_TOO_LARGE  : ");
      buf.append(HttpURLConnection.HTTP_ENTITY_TOO_LARGE).append("\n "); 
      buf.append("FORBIDDEN         : ");
      buf.append(HttpURLConnection.HTTP_FORBIDDEN).append("\n "); 
      buf.append("GATEWAY_TIMEOUT   : ");
      buf.append(HttpURLConnection.HTTP_GATEWAY_TIMEOUT).append("\n "); 
      buf.append("GONE              : ");
      buf.append(HttpURLConnection.HTTP_GONE).append("\n "); 
      buf.append("INTERNAL_ERROR    : ");
      buf.append(HttpURLConnection.HTTP_INTERNAL_ERROR).append("\n ");
      buf.append("LENGTH_REQUIRED   : ");
      buf.append(HttpURLConnection.HTTP_LENGTH_REQUIRED).append("\n "); 
      buf.append("MOVED_PERM        : ");
      buf.append(HttpURLConnection.HTTP_MOVED_PERM).append("\n "); 
      buf.append("MOVED_TEMP        : ");
      buf.append(HttpURLConnection.HTTP_MOVED_TEMP).append("\n "); 
      buf.append("MULT_CHOICE       : ");
      buf.append(HttpURLConnection.HTTP_MULT_CHOICE).append("\n "); 
      buf.append("NO_CONTENT        : ");
      buf.append(HttpURLConnection.HTTP_NO_CONTENT).append("\n "); 
      buf.append("NOT_ACCEPTABLE    : ");
      buf.append(HttpURLConnection.HTTP_NOT_ACCEPTABLE).append("\n "); 
      buf.append("NOT_AUTHORITATIVE : ");
      buf.append(HttpURLConnection.HTTP_NOT_AUTHORITATIVE).append("\n "); 
      buf.append("NOT_FOUND         : ");
      buf.append(HttpURLConnection.HTTP_NOT_FOUND).append("\n "); 
      buf.append("NOT_MODIFIED      : ");
      buf.append(HttpURLConnection.HTTP_NOT_MODIFIED).append("\n "); 
      buf.append("OK                : ");
      buf.append(HttpURLConnection.HTTP_OK).append("\n "); 
      buf.append("PARTIAL           : ");
      buf.append(HttpURLConnection.HTTP_PARTIAL).append("\n "); 
      buf.append("PAYMENT_REQUIRED  : ");
      buf.append(HttpURLConnection.HTTP_PAYMENT_REQUIRED).append("\n "); 
      buf.append("PRECON_FAILED     : ");
      buf.append(HttpURLConnection.HTTP_PRECON_FAILED).append("\n "); 
      buf.append("PROXY_AUTH        : ");
      buf.append(HttpURLConnection.HTTP_PROXY_AUTH).append("\n "); 
      buf.append("REQ_TOO_LONG      : ");
      buf.append(HttpURLConnection.HTTP_REQ_TOO_LONG).append("\n "); 
      buf.append("RESET             : ");
      buf.append(HttpURLConnection.HTTP_RESET).append("\n "); 
      buf.append("SEE_OTHER         : ");
      buf.append(HttpURLConnection.HTTP_SEE_OTHER).append("\n "); 
      buf.append("UNAUTHORIZED      : ");
      buf.append(HttpURLConnection.HTTP_UNAUTHORIZED).append("\n "); 
      buf.append("UNAVAILABLE       : ");
      buf.append(HttpURLConnection.HTTP_UNAVAILABLE).append("\n "); 
      buf.append("UNSUPPORTED_TYPE  : ");
      buf.append(HttpURLConnection.HTTP_UNSUPPORTED_TYPE).append("\n "); 
      buf.append("USE_PROXY         : ");
      buf.append(HttpURLConnection.HTTP_USE_PROXY).append("\n "); 
      buf.append("VERSION           : ");
      buf.append(HttpURLConnection.HTTP_VERSION).append("\n "); 

      System.out.println(buf.toString());
  }
//______________________________________________________________________________
/**
 * Parses the command line
 * Usage   : [-q|v|d][-V][-h] link
 * @param args the command line.
 */
public	boolean parseArg(String args[])
  {
    int i     = 0;
    int error = 0;

    while(i < args.length && args[i].startsWith("-")) {

      String arg = args[i++];
      int j;

      for (j = 1; j < arg.length(); j++) {

	char flag = arg.charAt(j);

	switch (flag) {
	case 'V':
	  VersionInfo.print();
	  break;

	case 'q':
	  ToolBox.verbose = false;
	  ToolBox.debug   = false;
	  break;

	case 'v':
	  ToolBox.verbose = true;
	  ToolBox.debug   = false;
	  break;

	case 'd':
	  ToolBox.verbose = true;
	  ToolBox.debug   = true;
	  break;

	default	:
	  printUsage();
	  printCodes();
	  error++;
	  break;
	}
      }
    }

    if(i < args.length)
	link = args[i];

    return (error == 0);
  }
//______________________________________________________________________________
}
