//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.demo.webwader;

import org.ariane.tools.*;

/**
 * CheckSite : a test program of the webwader package.
 * <P>
 * The content of the site is dumped in various orders.
 * The description can be saved in a plain file or in XML.
 *
 * @see WebSite
 * @version $Id: CheckSite.java,v 3.3 2000/11/05 14:33:16 lefevre Exp $
 * @author  Jean-Paul Le Fvre
 */

class CheckSite extends TryProg {
  /**
   * @serial The file describing the web site.
   */
    private String filename;

//______________________________________________________________________________
  /**
   * Starts the program
   */
public static void main (String args[])
  {
      ToolBox.debug   = true;
      ToolBox.verbose = true;

      CheckSite prog = new CheckSite("CheckSite");

      if (! prog.parseArg(args)) {
	  ToolBox.warn("Can't parse command line");
	  return;
      }
      else if (! prog.run()) {
	  ToolBox.warn("Can't run " + prog.getName());
	  return;
      }
  }
//______________________________________________________________________________
/**
 * Creates the object.
 * @param name the name of the program.
 */
public CheckSite(String name)
  {
    super(name);
  }
//______________________________________________________________________________
/**
 * Installs the specific resources.
 * @see	Resources
 */
protected void setResources()
  {
      resources = Resources.instance();
  }
//______________________________________________________________________________
/**
 * Actually starts the program.
 * <Br>
 * The description of the site is read in an ASCII file.
 * The site is checked.
 * The updated content is saved in a file.
 */
public	boolean run()
  {
      WebSite site = new WebSite();

      try {

	  if(ToolBox.verbose)
	      ToolBox.warn("Reading from " + filename);
	  site.read(filename);

	  WebNode node = site.getTopNode();
	  System.out.println();

	  System.out.print("BreadthFirst : ");
	  node.dumpBreadthFirst();
	  System.out.println();

	  System.out.print("PreOrder : ");
	  node.dumpPreorder();
	  System.out.println();

	  System.out.print("PostOrder : ");
	  node.dumpPostorder();
	  System.out.println();

	  String output = ToolBox.markAsTemp(filename);
	  site.write(output);
	  if(ToolBox.verbose) ToolBox.warn("Saved in " + output);

	  if(resources.get(Resources.PREFIX + "XML.Save", ToolBox.hasXML())) {
	      output = site.getName() + ".xml~";
	      site.writeXML(output);
	      if(ToolBox.verbose) ToolBox.warn("Saved in " + output);
	  }

      }
      catch (java.io.IOException ex) { 
	ToolBox.warn("Can't read or write site", ex);
	return false;
      }
      catch (Exception ex) {
	ToolBox.warn("Can't test site", ex);
	return false;
      }


      return true;
  }
//______________________________________________________________________________
    /**
     * Prints how to use the program.
     */
final private void printUsage()
  {
      System.out.println(
      "Usage   : java org.demo.webwader.CheckSite [options] filename");
      System.out.println(
      "Options : [-v|-d|-q][-V][-h]");
  }
//______________________________________________________________________________
/**
 * Parses the command line
 * Usage   : [-q|v|d][-V][-h] filename
 * @param args the command line.
 */
public	boolean parseArg(String args[])
  {
    int i     = 0;
    int error = 0;

    while(i < args.length && args[i].startsWith("-")) {

      String arg = args[i++];
      int j;

      for (j = 1; j < arg.length(); j++) {

	char flag = arg.charAt(j);

	switch (flag) {
	case 'V':
	  VersionInfo.print();
	  break;

	case 'q':
	  ToolBox.verbose = false;
	  ToolBox.debug   = false;
	  break;

	case 'v':
	  ToolBox.verbose = true;
	  ToolBox.debug   = false;
	  break;

	case 'd':
	  ToolBox.verbose = true;
	  ToolBox.debug   = true;
	  break;

	default	:
	  printUsage();
	  error++;
	  break;
	}
      }
    }

    if(i < args.length)
	filename = args[i];

    return (error == 0);
  }
//______________________________________________________________________________
}
