//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.tools;

/**
 * Provides information about the current release.
 * <Br>
 * It is a singleton.
 * @version $Id: VersionInfo.java,v 3.0 2000/08/23 13:15:35 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */
//______________________________________________________________________________

public class VersionInfo {
  /**
   * The version ID.
   */
public  final static String VERSION = "3.0";
  /**
   * The Release date.
   */
public  final static String DATE = "21 August 2000";
  /**
   * @serial The author.
   */
public  final static String AUTHOR = "Jean-Paul.LeFevre@cea.fr";
  /**
   * @serial The unique instance.
   */
private  static VersionInfo info = null;

//______________________________________________________________________________
/**
 * Gets an unique instance of the info.
 * <Br>
 * It is a singleton
 * @return the unique instance.
 */
public static VersionInfo instance()
  {
    if(info == null) info = new VersionInfo();

    return info;
  }
//______________________________________________________________________________
/**
 * Creates the VersionInfo.
 */
private VersionInfo()
  {
  }
//______________________________________________________________________________
    /**
     * Prints info on standart output.
     */
static public void print()
    {
	System.out.println(instance().toString());
    }
//______________________________________________________________________________
    /**
     * Returns info in a string.
     * @return the string.
     */
public String toString()
    {
	StringBuffer buf = new StringBuffer("JVS package : version ");
	buf.append(VERSION).append(" from ").append(DATE).append('.');

	return buf.toString();
    }
//______________________________________________________________________________
}


