//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.tools;

/**
 * TryProg : a base Class for applications.
 * @see Resources
 * @version $Id: TryProg.java,v 3.0 2000/08/23 13:15:35 lefevre Exp $
 * @author  Jean-Paul Le Fvre
 */
 
public class TryProg extends Nobject {

    /**
     * @serial The set of properties.
     */
    protected Resources resources;

//______________________________________________________________________________
  /**
   * Creates a TryProg.
   */
public TryProg()
  {
  }
//______________________________________________________________________________
  /**
   * Creates a TryProg. The resources are loaded from the properties files.
   * @param name the name of the program.
   * @see #setResources
   */
public TryProg(String name)
  {
      super(name);
      //			       First of all, set the options
      setResources();
      setVerbosity();
  }
//______________________________________________________________________________
/**
 * Installs the resources.
 * <Br>
 * This method can be overriden in subClasses to use different resources.
 * @see	Resources#load
 */
protected void setResources()
  {
      resources = Resources.instance();
      resources.load();
  }
//______________________________________________________________________________
/**
 * Sets the mode from the resource in the properties file.
 * <Br>
 * It can be unset, quiet, verbose or debug.
 * @see	ToolBox
 */
final protected	void setVerbosity()
  {
     String  mode = resources.get("Mode");
 
     if(mode == null) {
	 return;
     }
     else if(mode.equalsIgnoreCase("verbose")) {
	 ToolBox.verbose = true;
	 ToolBox.debug   = false;
     }
     else if(mode.equalsIgnoreCase("debug")) {
	 ToolBox.verbose = true;
	 ToolBox.debug   = true;
     }
     else if(mode.equalsIgnoreCase("quiet")) {
	 ToolBox.verbose = false;
	 ToolBox.debug   = false;
     }
  }
//______________________________________________________________________________
  /**
   * Encapsulates call to exit().
   * @see System#exit(int)
   */
protected static void exitWrong()
  {
      System.exit(ToolBox.WRONG);
  }
//______________________________________________________________________________
  /**
   * Parses the command line.
   * <Br>
   * Usage   : -v|d|q (verbose | debug | quiet)
   * @param args the array of arguments passed to the program.
   */
protected  boolean parseArg(String args[])
  {
    int i     = 0;
    int error = 0;

    while(i < args.length && args[i].startsWith("-")) {

      String arg = args[i++];
      int j;

      for (j = 1; j < arg.length(); j++) {

	char flag = arg.charAt(j);

	switch (flag) {
	case 'v':
	  ToolBox.verbose = true;
	  break;

	case 'd':
	  ToolBox.verbose = true;
	  ToolBox.debug   = true;
	  break;

	case 'q':
	  ToolBox.verbose = false;
	  ToolBox.debug   = false;
	  break;
	}
      }
    }

    return (error == 0);
  }
//______________________________________________________________________________
}


