//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.tools;
import java.io.BufferedReader;
import java.io.InputStreamReader;

/**
 * StreamReader : an object meant to read dataset.
 * It implements the basic stragegy to read a dataset.
 * It is made to simply iterate once on the lines.
 * It keeps track of the current line index.
 * This implementation should be revisited since there are similar
 * functionnalities in {@link java.io.LineNumberReader LineNumberReader}
 *
 * @see	InputDataset
 * @version $Id: StreamReader.java,v 3.0 2000/08/23 13:15:35 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */

public	class StreamReader extends Object implements LinesReader {
  /**
   * The associated reader.
   */
  private BufferedReader reader;
  /**
   * The current position : it is an index not a number.
   * It is the index of the next line not already read.
   */
   protected int line;
  /**
   * The character indicating a comment.
   */
  static private final String	com = "#";
  /**
   * The idle time.
   */
  private long laps;
  /**
   * The constant readAheadLimit.
   */
  static private final int limit = 1000000;

//______________________________________________________________________________
  /**
   * Creates a Reader.
   * @param input the associated Dataset.
   */
public StreamReader(InputDataset dataset)
  {
      if(dataset == null || dataset.input == null)
	  throw new IllegalArgumentException("Invalid input !");
      reader = new BufferedReader(new InputStreamReader(dataset.input));
      laps   = 0;
      reset();

      try {
	  reader.mark(limit);
      }
      catch(Exception ex) {
	  ToolBox.warn("Can't mark dataset", ex);
      }
  }
//______________________________________________________________________________
/**
 * Resets the Reader to the head of the dataset.
 * Bad implementation : close then reopen the dataset.
 */
public synchronized void rewind()
  {
      try {
	  reader.reset();
      }
      catch(Exception ex) {
	  ToolBox.warn("Can't rewind dataset", ex);
      }
  }
//______________________________________________________________________________
/**
  * Resets the position.
  */
protected synchronized void reset()
   {
       line = 0;
   }
//____________________________________________________________________________
/**
 * Closes the dataset.
 */
final public synchronized void close()
  {
      try {
	  reader.close();
	  reset();
      }
      catch(Exception ex) {
	  ToolBox.warn("Can't close dataset", ex);
      }
  }
//______________________________________________________________________________
  /**
   * Returns the number of the current line which was read.
   * @return the number.
   */
final public synchronized int lineNumber()
{
    return line - 1;
}
//______________________________________________________________________________
  /**
   * Changes the time to sleep between two lines read.
   * @param dt the new duration.
   */
final public void setIdleTime(long dt)
{
    laps = dt;
}
//______________________________________________________________________________
  /**
   * Reads the next line in the file.
   * <P>
   * Sleeps some milliseconds after each line read to
   * give other threads a chance to work.
   * Skip empty lines. Get rid of comments.
   * @return	the line.
   */
public synchronized String nextLine()
{
    String str = "";

    try {

	while ((str = reader.readLine()) != null) {
	
	    if(laps > 0) Thread.sleep(laps);
	    if(false)	System.out.println(str);
	    String tmp = str.trim();
	    if(tmp.length() < 1 || tmp.startsWith(com))	continue;

	    int i = str.indexOf(com);
	    if(i > 0) str = str.substring(0, i);
	    line++;

	    return str;
	}
    }
    catch(Exception ex) {
      ToolBox.warn("Error NextLine " + str); 
      ToolBox.warn("Can't read line " + lineNumber(), ex); 
    }

    return null;
  }
//______________________________________________________________________________
}




