//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.tools;

/**
 * SharedReader : a Reader with a shared buffer.
 * <P>
 * This buffer can be common to several readers.
 * @see	BufferReader
 * @version $Id: SharedReader.java,v 3.0 2000/08/23 13:15:35 lefevre Exp $
 * @author Jean-Paul Le F&egrave;vre
 */

public	class SharedReader extends Object implements LinesReader {
  /**
   * @serial The associated shared buffer reader.
   */
private	BufferReader reader;
  /**
   * The current position not shared.
   */
private int line;

//______________________________________________________________________________
  /**
   * Creates a Reader.
   */
public SharedReader()
  {
      line   = 0;
      reader = null;
  }
//______________________________________________________________________________
/**
 * Creates then sets the reader used to read the dataset.
 */
public	SharedReader(BufferReader br)
  {
      this();
      readFrom(br);
  }
//______________________________________________________________________________
/**
 * Sets the reader used to read the dataset.
 */
final public void readFrom(BufferReader br)
  {
      reader = br;
  }
//______________________________________________________________________________
/**
 * Resets the Reader to the head of the dataset.
 */
final public	synchronized void rewind()
  {
      line   = 0;
  }
//______________________________________________________________________________
  /**
   * Reads the next line in the dataset.
   * @return the line.
   * @see BufferReader#getLine
   */
final public String nextLine()
  {
      return reader.getLine(line++);
  }
//______________________________________________________________________________
  /**
   * Returns the number of the current line.
   * @return	the number.
   */
final public synchronized int lineNumber()
  {
    return line;
  }
//______________________________________________________________________________
}




