//______________________________________________________________________________

//	Java Virtual Shelf	- Jean-Paul Le Fvre
//______________________________________________________________________________

package org.ariane.tools;

import java.text.NumberFormat;

/**
 * RealNumber : a real number represented by a double.
 * <P>
 * It is an abstract Class. Concrete derived Classes must define
 * a format to display this number.
 *
 * @version $Id: RealNumber.java,v 3.0 2000/08/23 13:15:35 lefevre Exp $
 * @author Jean-Paul Le Fvre
 * @see Double
 */

abstract public class RealNumber extends Number {

    /**
     * @serial the value.
     */
private double v;

//______________________________________________________________________________
/**
 * Creates a real number.
 * @param v the value of this number.
 */
public RealNumber()
    {
	this.v = 0.0;
    }
//______________________________________________________________________________
/**
 * Creates a real number.
 * @param v the value of this number.
 */
public RealNumber(double v)
    {
	this.v = v;
    }
//______________________________________________________________________________
/**
 * Converts the number to a formatted string.
 * @return the string.
 * @see #getFormat
 */
final public String toString()
  {
    return getFormat().format(v);
  }
//______________________________________________________________________________
/**
 * Gets the format used to convert this number.
 * @return the format.
 * @see #toString
 */
abstract protected NumberFormat getFormat();

//______________________________________________________________________________
/**
 * Returns the stored value.
 * @return the value.
 */
public	double doubleValue()
  {
    return v;
  }
//______________________________________________________________________________
/**
 * Returns the stored value in long.
 * @return the value.
 */
public	int intValue()
  {
    return (int)v;
  }
//______________________________________________________________________________
/**
 * Returns the stored value in long.
 * @return the value.
 */
public	long longValue()
  {
    return (long)v;
  }
//______________________________________________________________________________
/**
 * Returns the stored value in long.
 * @return the value.
 */
public	float floatValue()
  {
    return (float)v;
  }
//______________________________________________________________________________
}




