//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.tools;

import java.io.*;
import java.util.Date;

/**
 * OutputDataset : a simple object to write data to. It encapsulates
 * operation on a PrintStream.
 * @see	PrintStream 
 * @version $Id: OutputDataset.java,v 3.0 2000/08/23 13:15:35 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */

public	final	class OutputDataset extends Nobject {
    /**
     * @serial the path to the output file.
     */
private	File file;
    /**
     * @serial the output stream.
     */
private	PrintStream output;

//______________________________________________________________________________
/**
 * Creates an output data set.
 * @param name the name of the file.
 */
public OutputDataset(String name)
  {
    super(name);
    file = new File(name);
  }
//______________________________________________________________________________
/**
 * Opens the output stream.
 * @exception	IOException if the stream cannot be open.
 * @see FileOutputStream
 * @see PrintStream
 */
final public void open() throws IOException
  {
    FileOutputStream fout =  new FileOutputStream(file.getPath());
    output = new PrintStream(fout);

    if(false)
      System.err.println("Output file " + getName() + " open !");
  }
//______________________________________________________________________________
/**
 * Closes the output stream.
 */
final public void close()
  {
    output.close();
  }
//______________________________________________________________________________
/**
 * Writes a header (the date, the filename ...) to the file.
 * @param	s an optionnal string to give info.
 * @see #writeFilet
 */
public final void writeHeader(String s)
  {
    Date today = new Date();
    writeFilet();
    writeLine("# Dataset " + getName() + " " + today);
    if(s != null) writeLine("# " + s);
    writeFilet();
  }
//______________________________________________________________________________
/**
 * Writes a footer (a filet) to the file.
 */
public final void writeFooter()
  {
    writeFilet();
  }
//______________________________________________________________________________
/**
 * Writes a newline character to the file.
 */
public final void writeNL()
  {
    output.println();
  }
//______________________________________________________________________________
/**
 * Writes a new line to the file. Add a newline character.
 * @param s the output string.
 * @see PrintStream#print(String)
 */
public final void writeLine(String s)
  {
    output.print(s); output.println();
  }
//______________________________________________________________________________
/**
 * Writes a characters array to the file.
 * @param s the output string.
 * @see	PrintStream#print(String)
 */
public final void writeChars(String s)
  {
    output.print(s);
  }
//______________________________________________________________________________
/**
 * Writes a straight line to the file.
 */
public final void writeFilet()
  {
    output.print(
"#_____________________________________________________________________________"
);
   output.println(); output.println(); 
  }
//______________________________________________________________________________
  /**
   * Prints info on stdout.
   */
public final void dump()
  {
    System.out.println("Dumping OutputDataset : " + file.getPath() + " !");
  }
//______________________________________________________________________________
}


