//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.tools;

/**
 * Nobject : a base Class for named object.
 * @see	Object
 * @version $Id: Nobject.java,v 3.0 2000/08/23 13:15:35 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */

public	class Nobject extends Object implements Nameable, java.io.Serializable {

  /**
   * @serial the name of the object.
   */
  private String  name;

//______________________________________________________________________________
  /**
   * Creates a Nobject named 'unnamed'.
   */
public Nobject()
  {
    this("unnamed");
  }
  /**
   * Creates a Nobject.
   * @param name the name of the Nobject.
   */
public Nobject(String name)
  {
    this.name = name;
  }
//______________________________________________________________________________
  /**
   * Returns the name of the object.
   * @return the name.
   */
public final String getName()
  {
    return name;
  }
//______________________________________________________________________________
  /**
   * Compares this Nobject to another specified Nobject.
   * Returns an integer that is less than, equal
   * to, or greater than zero. The integer's value depends on whether
   * the name is less than, equal to, or greater the name of the other Nobject.
   *
   * @param obj the object to compare to.
   * @see String#compareTo
   */
public int compareTo(Nobject obj)
  {
    return name.compareTo(obj.name);
  }
//______________________________________________________________________________
  /**
   * Renames the object.
   * <P>
   * The reference is simply copied. It is a shallow operation.
   * The deprecated SetName was a deep copy.
   * @param str	the new name.
   */
public final void setName(String name)
  {
    this.name = name;
  }
//______________________________________________________________________________
  /**
   * Compares two Nobjects for equality.
   * Returns a boolean that indicates whether this Nobject is equivalent 
   * to the specified Object.
   *
   * @param	obj	the Object to compare with.
   * @return	true if these Objects are equal; false otherwise.
   */
public boolean	equals(Object obj)
  {
    if (obj == null ||  ! (obj instanceof Nobject))
       return false;

    return name.equals(((Nobject)obj).name);
  }
//______________________________________________________________________________
/**
 * Returns a hashcode for this Object.
 * Each Object in the Java system has a hashcode. The hashcode
 * is a number that is usually different for different Objects.
 * It is used when storing Objects in hashtables.
 * Note: hashcodes can be negative as well as positive.
 * @see		java.util.Hashtable
 */
public int hashCode()
{
    return name.hashCode();
}
//______________________________________________________________________________
  /**
   * Builds a string made of the name.
   * @return str the string.
   */
public String toString()
  {
    return "Nobject " + name;
  }
//______________________________________________________________________________
  /**
   * Prints on stdout the name of the object (without newline).
   */
public void dump()
  {
    System.out.print("Name : "); System.out.print(name);
  }
//______________________________________________________________________________
}



