//______________________________________________________________________________

//	Java Virtual Shelf	- Jean-Paul Le Fvre
//______________________________________________________________________________

package org.ariane.tools;

import java.text.DecimalFormat;
import java.text.NumberFormat;

/**
 * FxpN : a Double which can be displayed with a
 * fixed point format.
 *
 * @version $Id: FxpN.java,v 3.0 2000/08/23 13:15:35 lefevre Exp $
 * @author Jean-Paul Le Fvre
 * @see DecimalFormat
 * @see ToolBox#scientificFormat
 */

final public class FxpN extends RealNumber {

    /**
     * @serial the format used to convert instances of this Class.
     */
static private DecimalFormat format;

static {
    format = ToolBox.scientificFormat("###,###,##0.00");
    }

//______________________________________________________________________________
/**
 * Creates a real number.
 * @param v the value of this number.
 */
public FxpN(double v)
    {
	super(v);
    }
//______________________________________________________________________________
/**
 * Gets the format used to convert this number.
 * @return the format.
 * @see #toString
 */
final protected NumberFormat getFormat()
    {
	return format;
    }
//______________________________________________________________________________
}




