//______________________________________________________________________________

//	Java Virtual Shelf	- Jean-Paul Le Fvre
//______________________________________________________________________________

package org.ariane.tools;

import java.text.DecimalFormat;
import java.text.NumberFormat;

/**
 * FlpN : a Double which can be displayed with a
 * floating point format.
 *
 * @version $Id: FlpN.java,v 3.0 2000/08/23 13:15:35 lefevre Exp $
 * @author Jean-Paul Le Fvre
 * @see DecimalFormat
 * @see ToolBox#scientificFormat
 */

final public class FlpN extends RealNumber {

    /**
     * @serial the format used to convert instances of this Class.
     */
static private DecimalFormat format;

static {
    format = ToolBox.scientificFormat("0.000E00");
    }
//______________________________________________________________________________
/**
 * Creates a real number.
 * @param v the value of this number.
 */
public FlpN(double v)
    {
	super(v);
    }
//______________________________________________________________________________
/**
 * Gets the format used to convert this number.
 * @return the format.
 * @see #toString
 */
final protected NumberFormat getFormat()
    {
	return format;
    }
//______________________________________________________________________________
}




