//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.tools;
import java.util.Iterator;
import java.util.Enumeration;

/**
 * Enumerator : an object used to iterate over a set of elements.
 * It converts an Enumeration to an Iterator : it is an Adaptor.
 *
 * @see java.util.Collection
 * @see java.util.Enumeration
 * @version $Id: Enumerator.java,v 3.0 2000/08/23 13:15:35 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */
//______________________________________________________________________________

public	final class Enumerator implements Iterator {
  /**
   * @serial Reference to the actual enumeration.
   */
  private Enumeration e;

//______________________________________________________________________________
/**
 * Creates an iterator on the collection.
 * @param e the enumeration on the data.
 */
public Enumerator(Enumeration e)
  {
    this.e = e;
  }
//______________________________________________________________________________
  /**
   * Checks whether there are more elements to be processed.
   * @return true if the iteration is not completed.
   * @see Enumeration#hasMoreElements
   */
final public boolean hasNext()
    {
	return e.hasMoreElements();
    }
//______________________________________________________________________________
  /**
   * Returns the next element in the iteration. It retrieves the next
   * data and returns the owner of this data.
   * @return the next object.
   * @see Enumeration#nextElement
   */
final public Object next()
    {
      return e.nextElement();
    }
//______________________________________________________________________________
    /**
     * Removes from the underlying collection the last element returned
     * by the iterator.
     * This operation is not implemented.
     * @throws UnsupportedOperationException
     */
final public void remove()
    {
	throw new UnsupportedOperationException("Can't remove element");
    }
//______________________________________________________________________________
}

