//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.tools;

import java.util.Iterator;

/** 
 * CoupleSet : a container for couples.
 * <P>
 * The implementation is based on the MiniSet's one.
 *
 * @version $Id: CoupleSet.java,v 3.0 2000/08/23 13:15:35 lefevre Exp $
 * @author Jean-Paul Le Fvre
 * @see	MiniSet
 * @see	Couple
 */
public	class CoupleSet extends Nobject {

  /**
   * @serial the array storing the elements.
   */
  private  MiniSet table;

//______________________________________________________________________________
  /**
   * Creates a Set named 'str'.
   * <Br>
   * The initial capacity is set to 10.
   * @see MiniSet
   * @parameter str the name of the set
   */
public CoupleSet(String str)
  {
   super(str);
   table = new MiniSet(10);
  }
//______________________________________________________________________________
  /**
   * Creates a Set named 'str'.
   * @see MiniSet
   * @parameter str the name of the set
   * @parameter size the initial capacity
   */
public CoupleSet(String str, int size)
  {
   super(str);
   table = new MiniSet(size);
  }
//______________________________________________________________________________
  /**
   * Returns an Enumeration to iterate on the set.
   * @return	the Iterator.
   */
public final synchronized Iterator iterator()
{
  return table.iterator();
}
//______________________________________________________________________________
  /**
   * Prints the content of the set to stdout.
   */
public void dump()
  {
    System.out.println(
    "Set : " + getName() + " size : " + table.size() + " (" + table.capacity()
    + ") objects !");

    for (Iterator e = table.iterator(); e.hasNext() ;) {
      Couple c = (Couple)e.next();
      System.out.println(c.o1.toString() + " " + c.o2.toString());
    }

    System.out.println();
  }
//______________________________________________________________________________
  /**
   * Returns the number of elements in the set.
   * @return the number of elements in the set.
   */
public final int size()
  {
    return table.size();
  }
//______________________________________________________________________________
  /**
   * Adds a Couple element to the set.
   * @param  (o1, o2) the couple to insert.
   */
public final void add(Object o1, Object o2)
  {
    add(new Couple(o1, o2));
  }
//______________________________________________________________________________
  /**
   * Adds a Couple element to the set.
   * @param  cpl the couple to insert.
   */
public final void add(Couple cpl)
  {
    table.add(cpl);
  }
//______________________________________________________________________________
  /**
   * Retrieves the element at position 'index' in the set.
   * @param  index the position.
   * @return a reference to the element.
   */
public final Couple get(int index)
  {
    return (Couple)table.get(index);
  }
//______________________________________________________________________________
  /**
   * Retrieves the first element in the set.
   * @return a reference to the element.
   * @see #get
   */
public final Couple getFirst()
  {
    return (Couple)table.get(0);
  }
//______________________________________________________________________________
  /**
   * Retrieves the last element in the set.
   * @return a reference to the element.
   * @see #get
   */
public final Couple getLast()
  {
    return (Couple)table.get(table.size() - 1);
  }
//______________________________________________________________________________
  /**
   * Creates a string giving information about the object.
   * @return the string.
   */
public String toString()
  {
      return table.toString();
  }
//______________________________________________________________________________
}




