//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.tools;

/**
 * Couple : a convenient object storing 2 objects.
 *
 * @see	Object
 * @version $Id: Couple.java,v 3.0 2000/08/23 13:15:35 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */
//______________________________________________________________________________

public	class Couple implements java.io.Serializable {

  /**
   * @serial The first element of the couple
   */
    public    Object o1;
  /**
   * @serial The second element of the couple
   */
    public    Object o2;

//______________________________________________________________________________
  /**
   * Creates a couple.
   * @param  (m1, m2) the members of the couple.
   */
public Couple(Object m1, Object m2)
  {
      o1 = m1; o2 = m2;
  }
//______________________________________________________________________________
  /**
   * Creates a string giving the content of the object.
   * @return the string.
   */
public String toString()
  {
      StringBuffer buf = new StringBuffer("(").append(String.valueOf(o1));
      buf.append(", ").append(String.valueOf(o2)).append(")");

      return buf.toString();
  }
//______________________________________________________________________________
}
