//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.tools;

import java.util.Iterator;
import java.util.Vector;
import java.util.NoSuchElementException;

/** 
 * BasicDataSet : a container for Basic Data.
 * <Br>
 * The implementation is based on the Vector's one. Note that it is not
 * an extension but a 'use' relationship.
 *
 * @version $Id: BasicDataSet.java,v 3.0 2000/08/23 13:15:35 lefevre Exp $
 * @author Jean-Paul Le Fvre
 * @see	BasicData
 * @see	Vector
 */
public	class BasicDataSet extends Nobject {

  /**
   * @serial The array storing the elements.
   */
  protected	Vector 	table;

/**
 * IdData : an convenient object implementing the abstract BasicData.
 * @version $Id: BasicDataSet.java,v 3.0 2000/08/23 13:15:35 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */

class IdData extends BasicData {
  /*
   * The total number of attributes.
   */
private int DATA_NBR = 1;

//______________________________________________________________________________
/**
 * Creates an id data.
 */
protected  IdData(String id)
  {
      data    = new String[DATA_NBR];
      data[0] = id;
  }
//______________________________________________________________________________
/**
 * Returns the number of data.
 */
final protected  int getDataNumber()
  {
      return DATA_NBR;
  }
//______________________________________________________________________________
}


//______________________________________________________________________________
  /**
   * Creates a Set named 'str'.
   * @see	BasicData
   * @see	Vector
   */
public BasicDataSet(String str)
  {
   super(str);
   table = new Vector(30, 5);
  }
//______________________________________________________________________________
  /**
   * Returns an Enumeration to iterate on the set.
   * @return	the Enumeration.
   * @see	Vector#iterator
   */
public final synchronized Iterator iterator()
{
  return table.iterator();
}
//______________________________________________________________________________
  /**
   * Minimizes used memory.
   * @see Vector#trimToSize
   */
public final synchronized void trimToSize()
  {
    table.trimToSize();
  }
//______________________________________________________________________________
  /**
   * Returns the number of elements in the set.
   * @return	the size.
   * @see Vector#size
   */
public final int size()
  {
    return table.size();
  }
//______________________________________________________________________________
  /**
   * Adds an element to the set.
   * @parameter obj the data object to add.
   * @see Vector#addElement
   */
public final void add(BasicData obj)
  {
    table.addElement(obj);
  }
//______________________________________________________________________________
  /**
   * Retrieves an element named 'str' in the set.
   * @parameter id the ident of the data to be searched.
   * @return a reference to the element or null if not found.
   */
public final BasicData	get(String id)
  {
    IdData obj  = new IdData(id);
    int index   = table.indexOf(obj);

    if(index <  0)
      return null;

    return (BasicData)table.elementAt(index);
  }
//______________________________________________________________________________
  /**
   * Retrieves the element at position 'index' in the set.
   * @param  index the position.
   * @return a reference to the element.
   * @see	Vector#elementAt
   */
public final BasicData	get(int index)
  {
    return (BasicData)table.elementAt(index);
  }
//______________________________________________________________________________
  /**
   * Retrieves the first element in the set.
   * @return a reference to the element.
   * @see	Vector#elementAt
   */
public final BasicData	getFirst()
  {
    return (BasicData)table.elementAt(0);
  }
//______________________________________________________________________________
  /**
   * Retrieve the last element in the set.
   * @return a reference to the element.
   * @see	Vector#elementAt
   */
public final BasicData	getLast()
  {
    return (BasicData)table.elementAt(table.size() - 1);
  }
//______________________________________________________________________________
  /**
   * Returns the position of an element in the set.
   * @parameter	the reference to the element.
   * @return 	the position.
   * @see	Vector#indexOf
   */
public final int indexOf(BasicData obj)
  {
    return table.indexOf(obj);
  }
//______________________________________________________________________________
  /**
   * Prints the content of the set on stdout.
   */
public void  dump()
  {
    System.out.println(
    "Set : " + getName() + " size : " + table.size() + " (" + table.capacity()
    + ") basic data !");

    Iterator e;

    for (e = table.iterator(); e.hasNext() ;) {
      BasicData n = (BasicData)e.next();
      System.out.println(n.toString());
    }

    System.out.println();
  }
//______________________________________________________________________________
}
