//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.tools;

/**
 * BasicData : the object storing information.
 * <Br>
 * The first attribute, the id, is supposed to be unique.
 * It can be used to compare two objects.
 * The attributes are strings.
 * @version $Id: BasicData.java,v 3.0 2000/08/23 13:15:35 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */

abstract public class BasicData extends Object {
  /*
   * @serial The array of attributes.
   */
protected String[] data;

//______________________________________________________________________________
/**
 * Returns the number of data.
 */
abstract protected  int	getDataNumber();

//______________________________________________________________________________
/**
 * Gets a reference to a specific data.
 * @parameter index specifies which data is needed.
 * @return the attribute.
 * @exception IllegalArgumentException if index is not valid.
 */
final public String get(int index) throws IllegalArgumentException
  {
    if(index < 0 || index >= getDataNumber()) {
	throw new IllegalArgumentException("Invalid index " + index);
    }
      return data[index];
  }
//______________________________________________________________________________
/**
 * Sets a reference to a specific data.
 * @parameter index specifies which data is stored.
 * @parameter value is the new value.
 * @exception IllegalArgumentException if index is not valid.
 */
final public void set(int index, String value) throws IllegalArgumentException
  {
      if(index < 0 || index >= getDataNumber())
	  throw new IllegalArgumentException("Invalid index " + index);
      data[index] = value;
  }
//______________________________________________________________________________
  /**
   * Builds a string made of the attributes
   * @return str	the string.
   */
public String toString()
  {
      StringBuffer buf = new StringBuffer(data[0]);
      buf.append(" : ");

      for(int i = 1; i < getDataNumber(); i++) {
	  buf.append(data[i]).append(", ");
      }

      return buf.toString();
  }
//______________________________________________________________________________
  /**
   * Compares two Basicdata for equality : checks ONLY id. (not type)
   * Returns a boolean that indicates whether this BasicData is equivalent 
   * to the specified Object.
   * @param	obj	the Object to compare with.
   * @return	true if these Objects are equal; false otherwise.
   */
public boolean	equals(Object obj)
  {
    if (obj == null)
       return false;

    return data[0].equals(((BasicData)obj).data[0]);
  }
//______________________________________________________________________________
}
