//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.time;

import java.util.Date;
import java.text.SimpleDateFormat;

/**
 * Time : manage a date. Encapsulate Date.
 * @see	Date
 * @version $Id: Time.java,v 3.0 2000/08/23 13:15:34 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */

public	final	class Time extends Object {
  /**
   *	@serial the encapsulated date.
   */
protected Date date;
  /**
   *	@serial the array of month.
   */
private final static String month[] = {
	"January", "February", "March", "April", "May", "June",
	"July", "August", "September", "October", "November", "December",
    };
    /**
     * @serial my standard format
     */
static protected SimpleDateFormat stdfmt;
static {
    stdfmt = new SimpleDateFormat("hh:mm:ss dd/MM");
};
//______________________________________________________________________________
/**
 * Time : Sets to the date.
 */
public Time()
{
    date = new Date();
}
//______________________________________________________________________________
/**
 * Time : Sets to the specified time.
 * @param t the time since the epoch.
 */
public Time(long t)
{
    date = new Date(t);
}
//______________________________________________________________________________
/**
 * Time : Sets to the specified date.
 * @param d the date
 */
public Time(Date d)
{
    date = d;
}
//______________________________________________________________________________
/**
 * Time : Sets to the date.
 * @param d the calendar
 */
public Time(Calendar d)
{
    date = new Date(d.getTime().getTime());
}
//______________________________________________________________________________
/**
 * Converts Time to String. Discard TZ and year.
 * @return str	the string.
 */
public String toString()
{
    return stdfmt.format(date);
}
//______________________________________________________________________________
/**
 * Returns the date in the form dd/mm
 * @return str	the string.
 */
final public String dayMonth()
{
    SimpleDateFormat fmt = new SimpleDateFormat("dd MMM");

    return fmt.format(date);
}
//______________________________________________________________________________
}




