//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.time;

import java.util.Date;

/**
 * Duration : manage a time interval
 * @see	Date
 * @version $Id: Duration.java,v 3.0 2000/08/23 13:15:34 lefevre Exp $
 * @author Jean-Paul Le F&egrave;vre
 */
//______________________________________________________________________________

public	final	class Duration extends Object {

  /*
   * Some durations in milliseconds.
   */
static	final	public double	SECOND =     1000.;
static	final	public double	MINUTE =    60000.;
static	final	public double	HALF   =  1800000.;
static	final	public double	HOUR   =  3600000.;
static	final	public double	DAY    = 86400000.;

/**
 * The value of the duration in milliseconds.
 */
private long value;

public Duration()
  {
    value = 0;
  }
//______________________________________________________________________________
/**
 * Duration between two dates.
 * @param d1 the first date;
 * @param d2 the last date.
 */
public Duration(Date d1, Date d2)
  {
    value = d2.getTime() - d1.getTime();
  }
//______________________________________________________________________________
  /**
   * Convert Duration in String.
   * @return the string.
   */
public String	toString()
  {
    return new String("D : " + value + " ms.");
  }
//______________________________________________________________________________
  /**
   * Get the value in milliseconds
   * @return the value.
   */
final public long value()
  {
    return value;
  }
//______________________________________________________________________________
  /**
   * Convert Duration in number of days.
   * @return the number of days.
   */
final public int inDays()
  {
    return (int)(0.5 + (double)value / DAY);
  }
//______________________________________________________________________________
  /**
   * Convert Duration in number of hours.
   * @return the number of hours.
   */
final public int inHours()
  {
    return (int)(0.5 + (double)value / HOUR);
  }
//______________________________________________________________________________
  /**
   * Convert Duration in number of half hours (30 minutes).
   * @return the number of hours.
   */
final public int inHalfHours()
  {
    return (int)(0.5 + ((double)value) / HALF);
  }
//______________________________________________________________________________
}








