//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.time;

import org.ariane.tools.Nobject;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import java.util.NoSuchElementException;

/** 
 * DatedDataSet : a container for Dated Data.
 * <Br>
 * The implementation is based on the Vector's one.
 *
 * @version $Id: DatedDataSet.java,v 3.0 2000/08/23 13:15:34 lefevre Exp $
 * @author Jean-Paul Le Fvre
 * @see	DatedData
 * @see	Vector
 */
public	class DatedDataSet extends Nobject {
  /**
   * @serial the array storing the elements.
   */
  protected Vector table;

//______________________________________________________________________________
  /**
   * Creates a Set named 'str'.
   * @see DatedData
   * @see Vector
   */
public DatedDataSet(String str)
  {
   super(str);
   table = new Vector(50, 5);
  }
//______________________________________________________________________________
  /**
   * Returns an Enumeration to iterate on the set.
   * @return the Enumeration.
   * @see Vector#iterator
   */
public final synchronized Iterator iterator()
{
  return table.iterator();
}
//______________________________________________________________________________
  /**
   * Minimizes used memory.
   * @see Vector#trimToSize
   */
public final synchronized void trimToSize()
  {
    table.trimToSize();
  }
//______________________________________________________________________________
  /**
   * Returns the number of elements in the set.
   * @return the size.
   * @see Vector#size
   */
public final int size()
  {
    return table.size();
  }
//______________________________________________________________________________
  /**
   * Adds an element to the set.
   * @parameter obj the data object to add.
   * @see Vector#addElement
   */
public final void add(DatedData obj)
  {
    table.addElement(obj);
  }
//______________________________________________________________________________
  /**
   * Retrieves the element at position 'index' in the set.
   * @param  index the position.
   * @return a reference to the element.
   * @see Vector#elementAt
   */
public final DatedData get(int index)
  {
    return (DatedData)table.elementAt(index);
  }
//______________________________________________________________________________
  /**
   * Retrieves the first element in the set.
   * @return a reference to the element.
   * @see Vector#elementAt
   */
public final DatedData getFirst()
  {
    return (DatedData)table.elementAt(0);
  }
//______________________________________________________________________________
  /**
   * Retrieve the last element in the set.
   * @return a reference to the element.
   * @see Vector#elementAt
   */
public final DatedData getLast()
  {
    return (DatedData)table.elementAt(table.size() - 1);
  }
//______________________________________________________________________________
  /**
   * Returns the position of an element in the set.
   * @parameter	the reference to the element.
   * @return the position.
   * @see Vector#indexOf
   */
public final int indexOf(DatedData obj)
  {
    return table.indexOf(obj);
  }
//______________________________________________________________________________
  /**
   * Prints the content of the set on stdout.
   */
public void dump()
  {
    System.out.println(
    "Set : " + getName() + " size : " + table.size() + " (" + table.capacity()
    + ") dated data !");

    Iterator e;

    for (e = table.iterator(); e.hasNext() ;) {
      DatedData n = (DatedData)e.next();
      System.out.println(n.toString());
    }

    System.out.println();
  }
//______________________________________________________________________________
}




