//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.time;

import java.util.Date;

/**
 * DatedDataFactory : an object creating DatedData.
 * @see DatedData
 * @version $Id: DatedDataFactory.java,v 3.0 2000/08/23 13:15:34 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */

abstract public class DatedDataFactory extends Object {

//______________________________________________________________________________
/**
 * Creates a DatedData.
 * @return the object.
 */
abstract public  DatedData create(Date d);

//______________________________________________________________________________
/**
 * Creates the first  object in a suite.
 * @return the object.
 */
abstract public  DatedData createFirst();

//______________________________________________________________________________
/**
 * Creates the next object.
 * @parameter obj the object of reference.
 * @return the following object.
 */
final public  DatedData createNext(DatedData obj)
  {
      return create(obj.getNextDate());
  }
//______________________________________________________________________________
/**
 * Creates the previous object.
 * @parameter obj the object of reference.
 * @return the preceding object.
 */
final public  DatedData createPrevious(DatedData obj)
  {
      return create(obj.getPreviousDate());
  }
//______________________________________________________________________________
}


