//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.time;

import java.util.Date;

/**
 * DatedData : the object storing information at a particular date.
 * @see Date
 * @version $Id: DatedData.java,v 3.0 2000/08/23 13:15:34 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */

abstract public class DatedData extends Object {
  /*
   * The date.
   */
protected Date date;

//______________________________________________________________________________
/**
 * Creates an object for right now.
 */
public DatedData()
{
    this(new Date());
}
//______________________________________________________________________________
/**
 * Creates an object at the specified date.
 * @parameter d the date.
 */
public DatedData(Date d)
{
    date = d;
}
//______________________________________________________________________________
/**
 * Gets the date.
 * @return the date.
 */
final public  Date getDate()
  {
      return date;
  }
//______________________________________________________________________________
/**
 * Returns the number of milliseconds since January 1, 1970, 00:00:00 GMT
 * represented by the date.
 * @return the time since the epoch.
 * @see Date#getTime
 */
final public  long getTime()
  {
      return date.getTime();
  }
//______________________________________________________________________________
/**
 * Returns the Calendar associated with the data.
 * The calendar is in the UTC zone. (no DST)
 * @return the Calendar.
 * @see Calendar
 */
final public  Calendar getCalendar()
  {
      return Calendar.getUTCCalendar(date);
  }
//______________________________________________________________________________
/**
 * Gets the date of the next object.
 * @return the date.
 */
abstract public  Date getNextDate();
//______________________________________________________________________________
/**
 * Gets the date of the next object.
 * @return the date.
 */
abstract public  Date getPreviousDate();

//______________________________________________________________________________
  /**
   * Builds a string made of the attributes
   * @return str	the string.
   */
public String	toString()
  {
      return date.toString();
  }
//______________________________________________________________________________
  /**
   * Tests if this data is after the specified data.
   * @parameter dd the data to compare.
   * @return true if this data is after the argument data; false otherwise.
   */
final public boolean	after(DatedData dd)
  {
      return date.after(dd.date);
  }
//______________________________________________________________________________
  /**
   * Tests if this data is before the specified data.
   * @parameter dd the data to compare.
   * @return true if this data is before the argument data; false otherwise.
   */
final public boolean	before(DatedData dd)
  {
      return date.before(dd.date);
  }
//______________________________________________________________________________
  /**
   * Compares two DatedData for equality : checks date.
   * <br>
   * Returns a boolean that indicates whether this DatedData is equivalent 
   * to the specified Object.
   * @param	obj	the Object to compare with.
   * @return	true if these Objects are equal; false otherwise.
   */
public boolean	equals(Object obj)
  {
    if (obj == null ||  ! (obj instanceof DatedData))
       return false;

    return date.equals(((DatedData)obj).date);
  }
//______________________________________________________________________________
}
