//______________________________________________________________________________

//	Java Test program
//______________________________________________________________________________

package org.ariane.time;

import java.util.Date;
import java.text.SimpleDateFormat;
import org.ariane.tools.ToolBox;

/**
 * Test program for Class SimpleDateFormat.
 *
 * @see Date
 * @see SimpleDateFormat
 * @author Jean-Paul Le Fvre
 * @version $Id: CheckDate.java,v 3.0 2000/08/23 13:15:34 lefevre Exp $
 */

class CheckDate {

public static void main (String args[])
  {
      String pattern = "ddMMyy";

      if(args.length < 1) {
	  System.err.println("Usage java org.ariane.time.CheckDate " + pattern);
	  System.exit(1);
      }

      SimpleDateFormat fmt = new SimpleDateFormat(pattern);

      try {
	  Date date = fmt.parse(args[0]);
	  System.out.println(date.toString());
      }
      catch(Exception ex) {
 	  System.err.println("Invalid date format : " + args[0]
			     + " # " + pattern);
	  ToolBox.warn("Can't parse date", ex);
      }
  }
//______________________________________________________________________________

}


