//______________________________________________________________________________

//	The Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.test;

import org.ariane.tools.*;
import org.ariane.exec.RandomTask;

/**
 * A test program for RandomTask.
 *
 * @see RandomTask
 * @version $Id: TryTask.java,v 3.0 2000/08/23 13:15:34 lefevre Exp $
 * @author  Jean-Paul Le Fvre
 */

class TryTask extends TryProg implements Runnable {

    /**
     * @serial the main thread.
     */
private	Thread		maintask;
    /**
     * @serial the task to check.
     */
private	RandomTask	task;
    /**
     * @serial the name of the task.
     */
private	String		taskname;
    /**
     * @serial the number of loops.
     */
private	int		loops;

//______________________________________________________________________________

public static void main (String args[])
  {

    TryTask prog = new TryTask("TryTask");

    if (! prog.parseArg(args)) {
      System.err.println("Can't parse command line !");
      return;
    }
    else if (! prog.build()) {
      System.err.println("Can't build TryTask !");
      return;
    }
    else if (! prog.start()) {
      System.err.println("Can't start TryTask !");
      return;
    }

  }
//______________________________________________________________________________

public TryTask(String name)
  {
    super(name);
  }
//______________________________________________________________________________

public	boolean build()
  {
    task     = new RandomTask(taskname, loops);
    maintask = new Thread(this, getName());

    return true;
  }
//______________________________________________________________________________

public	boolean start()
  {
      if(ToolBox.verbose)
	  System.err.println("Running " +taskname + " " + loops + " times ...");
      maintask.start();

      return true;
  }
//______________________________________________________________________________

public	void run()
  {
    task.start();

    while(! task.isDone()) {
      System.err.println("Count " + task.getCount());
      try {
	  maintask.sleep(100);
      } catch (InterruptedException ex) {}
    }
  }
//______________________________________________________________________________
    /**
     * Purpose : parse the command line.
     * Usage   : -v|d -n loops taskname
     */
public	boolean parseArg(String args[])
  {
    int i     = 0;
    int error = 0;

    while(i < args.length && args[i].startsWith("-")) {

      String arg = args[i++];
      int j;

      for (j = 1; j < arg.length(); j++) {

	char flag = arg.charAt(j);

	switch (flag) {
	case 'v':
	  ToolBox.verbose = true;
	  break;

	case 'd':
	  ToolBox.verbose = true;
	  ToolBox.debug   = true;
	  break;

	case 'n':
	  loops = Integer.parseInt(args[i++]);
	  break;
	}
      }
    }

    if(i < args.length)
      taskname = args[i];
    else
      return false;

    return (error == 0);
  }
//______________________________________________________________________________
}

