//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.test;

import org.ariane.tools.*;

/**
 * A test program for String.
 *
 * @version $Id: TryString.java,v 3.0 2000/08/23 13:15:34 lefevre Exp $
 * @author  Jean-Paul Le F&egrave;vre
 */

class TryString extends TryProg {
  /**
   * @serial the string to process.
   */
private	String	string;
  /**
   * @serial the requested width.
   */
private	int	width;

//______________________________________________________________________________

public static void main (String args[])
  {

    TryString prog = new TryString("TryString");

    if (! prog.parseArg(args)) {
      System.err.println("Can't parse command line !");
      exitWrong();
    }

    if (! prog.run()) {
      System.err.println("Can't execute TryString !");
      exitWrong();
    }

  }
//______________________________________________________________________________

public TryString(String name)
  {
    super(name);
    string = null;
    width  = 0;
  }
//______________________________________________________________________________

public	boolean run()
  {
    if(ToolBox.verbose)
      System.out.println("Running TryString on " + string + " ...");

    System.out.println("-" + ToolBox.centerString(string, width) + "-");
    System.out.println("-" + ToolBox.padString(string, width) + "-");

    return true;
  }
//______________________________________________________________________________
    /**
     * Purpose : parse the command line.
     * Usage   : -v|d -w width string
     */
public	boolean parseArg(String args[])
  {
    int i     = 0;
    int error = 0;

    while(i < args.length && args[i].startsWith("-")) {

      String arg = args[i++];
      int j;

      for (j = 1; j < arg.length(); j++) {

	char flag = arg.charAt(j);

	switch (flag) {
	case 'v':
	  ToolBox.verbose = true;
	  break;

	case 'd':
	  ToolBox.verbose = true;
	  ToolBox.debug   = true;
	  break;

	case 'w':
	  width = Integer.parseInt(args[i++]);
	  break;
	}
      }
    }

    if(i < args.length)
      string = args[i];
    else
      return false;

    return (error == 0);
  }
//______________________________________________________________________________
}

