//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.test;

import org.ariane.tools.*;
import org.ariane.stats.*;

/**
 * A test program for ValueCountSet.
 *
 * @see ValueCountSet
 * @version $Id: TryStat.java,v 3.0 2000/08/23 13:15:34 lefevre Exp $
 * @author  Jean-Paul Le F&egrave;vre
 */

class TryStat extends TryProg {

    /**
     * @serial the name of the file.
     */
private	String		filename;
    /**
     * @serial the set to test.
     */
private	ValueCountSet	set;

//______________________________________________________________________________

public static void main (String args[])
  {

    TryStat prog = new TryStat("TryStat");

    if (! prog.parseArg(args)) {
      System.err.println("Can't parse command line !");
      return;
    }

    if (! prog.run()) {
      System.err.println("Can't execute TryStat !");
      return;
    }

  }
//______________________________________________________________________________

public TryStat(String name)
  {
    super(name);
    set = new ValueCountSet("Statistics");
  }
//______________________________________________________________________________

public	boolean run()
  {
    if(ToolBox.verbose)
      System.err.println("Running TryStat on " + filename + " ...");

    if (! load()) {
      System.err.println("Can't load data !");
      return false;
    }

    set.sort();
    set.dump();

    return true;
  }
//______________________________________________________________________________

private	boolean load()
  {
    InputDataset file = new InputDataset(filename);
    if(ToolBox.debug)	file.dump();
    int l = 0;

    try {

      file.open();

      String line;

      while((line = file.getNextLine()) != null) {

	set.count(Integer.parseInt(line)); l++;

      }

      file.close();
    }
    catch(Exception e) {
      System.err.println("Can't read file " + file.getName() + " !");
      System.out.println("Exception caught : " + e + " line " + l + " !"); 
      return false;
    }

    set.trimToSize();

    return true;
  }
//______________________________________________________________________________
    /**
     * Purpose : parse the command line.
     * Usage   : -v|d filename
    */
public	boolean parseArg(String args[])
  {
    int i     = 0;
    int error = 0;

    while(i < args.length && args[i].startsWith("-")) {

      String arg = args[i++];
      int j;

      for (j = 1; j < arg.length(); j++) {

	char flag = arg.charAt(j);

	switch (flag) {
	case 'v':
	  ToolBox.verbose = true;
	  break;

	case 'd':
	  ToolBox.verbose = true;
	  ToolBox.debug   = true;
	  break;
	}
      }
    }

    if(i < args.length)
      filename = args[i];
    else
      return false;

    return (error == 0);
  }
//______________________________________________________________________________
}

