//______________________________________________________________________________

//	The Java Virtual Shelf	- Jean-Paul Le Fvre
//______________________________________________________________________________

package org.ariane.test;

import org.ariane.tools.*;
import java.io.*;

/**
 * Tests read and write on serialized objects.
 * Usage   : [-v|d] -r | -w filename
 * -r : read from filename.
 * -w : write to filename.
 *
 * @version $Id: TrySerial.java,v 3.0 2000/08/23 13:15:34 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */

class TrySerial extends Nobject {

    /**
     * @serial the file where to read or write.
     */
transient private String filename;
    /**
     * @serial if dowrite is true write else read.
     */
transient private boolean dowrite;

    class Target extends Nobject implements Serializable {

	static final long serialVersionUID = -4930254239926841853L;

	protected Target(String name)
	{
	    super(name);
	}
	/**
	 * Builds a string made of the name.
	 * @return str the string.
	 */
	public String	toString()
	{
	    return "New implementation of " + getName();
	}
    }

//______________________________________________________________________________

public static void main (String args[])
  {
    TrySerial prog = new TrySerial();

    if (! prog.parseArg(args)) {
      System.err.println("Can't parse command line !");
      return;
    }

    prog.run();
  }
//______________________________________________________________________________
    /**
     * Creates the object and initialize the variables.
     */
public TrySerial()
  {
    super("TrySerial");
    filename  = null;
    dowrite = false;
  }
//______________________________________________________________________________
    /**
     * Reads or Writes object on the specified file.
     */
private void run()
  {
      if(dowrite) {
	  ToolBox.warn("Writing to " + filename);
	  write();
      }
      else {
	  ToolBox.warn("Reading in " + filename); 
	  read();
      }
  }
//______________________________________________________________________________
    /**
     * Writes down the object to the specified file.
     */
private void write()
  {
      try {
	  FileOutputStream file  = new FileOutputStream(filename);
	  ObjectOutputStream out = new ObjectOutputStream(file);

	  Target object = new Target("sample");

	  out.writeObject(object);
	  out.close();

	  if(ToolBox.verbose) ToolBox.warn("Written  : " + object.toString());
      }
      catch(IOException ex) {
	  ToolBox.warn("Can't write the object", ex);
	  ex.printStackTrace();
      }
  }
//______________________________________________________________________________
    /**
     * Reads the object from the specified file.
     */
private void read()
  {
      try {
	  FileInputStream file = new FileInputStream(filename);
	  ObjectInputStream in = new ObjectInputStream(file);

	  Target object = (Target)in.readObject();

	  in.close();
	  ToolBox.warn("Read     : " + object.toString()); 
      }
      catch(ClassNotFoundException ex) {
	  ToolBox.warn("Can't create the object", ex);
	  ex.printStackTrace();
      }
      catch(IOException ex) {
	  ToolBox.warn("Can't read the object", ex);
	  ex.printStackTrace();
      }
  }
//______________________________________________________________________________
    /**
     * Parses the command line.
     * Usage   : [-v|d|q] -r | -w filename
     */
public	boolean parseArg(String args[])
  {
    int i     = 0;
    int error = 0;

    while(i < args.length && args[i].startsWith("-")) {

      String arg = args[i++];
      int j;

      for (j = 1; j < arg.length(); j++) {

	char flag = arg.charAt(j);

	switch (flag) {
	case 'q':
	  ToolBox.verbose = false;
	  ToolBox.debug   = false;

	  break;
	case 'v':
	  ToolBox.verbose = true;
	  ToolBox.debug   = false;
	  break;

	case 'd':
	  ToolBox.verbose = true;
	  ToolBox.debug   = true;
	  break;

	case 'r':
	  dowrite = false;
	  break;

	case 'w':
	  dowrite = true;
	  break;

	default :
	  error++;
	}
      }
    }

    if(i < args.length) {
	filename = args[i++];
    }
    else {
	error++;
    }

    return (error == 0);
  }
//______________________________________________________________________________
}


