//______________________________________________________________________________

//	The Java Virtual Shelf	- Jean-Paul Le Fvre
//______________________________________________________________________________

package org.ariane.test;

import org.ariane.tools.*;
import org.ariane.net.*;
import org.ariane.time.Calendar;
import java.io.*;
import java.net.*;

/**
 * Tests read and write on URLs.
 * <br>
 * Usage   : [-v|d] [-s string] -r | -w target
 * -s : string is an optionnal string to write.
 * -r : read from target.
 * -w : write to target.
 * target may be a plain file or an url.
 *
 * @see NetHost
 * @version $Id: TryRWurl.java,v 3.0 2000/08/23 13:15:34 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */

class TryRWurl extends TryProg {

    /**
     * @serial the url or the plain file where to read or write.
     */
private String target;
    /**
     * @serial the string to write.
     */
private String message;
    /**
     * @serial if dowrite is true write else read.
     */
private boolean dowrite;

//______________________________________________________________________________

public static void main (String args[])
  {
    TryRWurl prog = new TryRWurl();

    if (! prog.parseArg(args)) {
      System.err.println("Can't parse command line !");
      return;
    }

    prog.run();
  }
//______________________________________________________________________________
    /**
     * Creates the object and initialize the variables.
     */
public TryRWurl()
  {
    super("TryRWurl");
    target  = null;
    message = null;
    dowrite = false;
  }
//______________________________________________________________________________
    /**
     * Reads or Writes message on the specified url
     */
private void run()
  {
      if(dowrite) {
	  ToolBox.warn("Writing to " + target);
	  write();
      }
      else {
	  ToolBox.warn("Reading in " + target); 
	  read();
      }
  }
//______________________________________________________________________________
    /**
     * Writes the message to the specified url.
     * The output can be either a plain file or an url.
     */
private void write()
  {
      try {
	  OutputStreamWriter writer;

	  if(isURL(target)) {
	      URL url = new URL(target);
	      URLConnection co = url.openConnection();
	      co.setDoOutput(true);
	      writer = new OutputStreamWriter(co.getOutputStream());
	  }
	  else {
	      FileOutputStream file = new FileOutputStream(target);
	      writer                = new OutputStreamWriter(file);
	  }

	  PrintWriter out = new PrintWriter(writer);
	  message         = "Message issued by " + getName() + " on "
	                     +  (new Calendar()).toString();
	  out.println(message);
	  out.close();
	  if(ToolBox.verbose) ToolBox.warn("Message written to " + target);
      }
      catch(IOException ex) {
	  ToolBox.warn("Can't write the message", ex);
	  ex.printStackTrace();
      }
  }
//______________________________________________________________________________
    /**
     * Reads the message from the specified url.
     * The input can be either a plain file or an url.
     */
private void read()
  {
      try {
	  InputStreamReader reader;

	  if(isURL(target)) {
	      URL url = new URL(target);
	      URLConnection co = url.openConnection();
	      reader = new InputStreamReader(co.getInputStream());
	  }
	  else {
	    FileInputStream file = new FileInputStream(target);
	    reader  = new InputStreamReader(file);
	  }

	  BufferedReader in = new BufferedReader(reader);
	  message = in.readLine();
	  in.close();
	  ToolBox.warn("Read     : " + message); 
      }
      catch(IOException ex) {
	  ToolBox.warn("Can't read the message", ex);
	  ex.printStackTrace();
      }
  }
//______________________________________________________________________________
    /**
     * Parses the command line.
     * Usage   : [-v|d] [-s string] -r | -w target
     */
public	boolean parseArg(String args[])
  {
    int i     = 0;
    int error = 0;

    while(i < args.length && args[i].startsWith("-")) {

      String arg = args[i++];
      int j;

      for (j = 1; j < arg.length(); j++) {

	char flag = arg.charAt(j);

	switch (flag) {
	case 'v':
	  ToolBox.verbose = true;
	  break;

	case 'd':
	  ToolBox.verbose = true;
	  ToolBox.debug   = true;
	  break;

	case 's':
	  message = args[i++];
	  break;

	case 'r':
	  dowrite = false;
	  break;

	case 'w':
	  dowrite = true;
	  break;

	default :
	  error++;
	}
      }
    }

    if(i < args.length) {
	target = args[i++];
    }
    else {
	error++;
    }

    return (error == 0);
  }
//______________________________________________________________________________
    /**
     * Checks to see if a string represents an url or a plain file name.
     * @return true if it is an url
     */
private boolean isURL(String str)
    {
	return str.indexOf("://") >= 0;
    }
//______________________________________________________________________________
}


