//______________________________________________________________________________

//	Java Test program
//______________________________________________________________________________

package org.ariane.test;

import org.ariane.tools.*;
import java.util.Properties;

/**
 * Test program for Properties.
 * <P>
 * Usage : java -DDef.On.Line=something org.ariane.test.TryProp [-vd] filename
 * <Br>
 * It dumps the content of the properties files.
 * It gives also the current value of some environment variables
 * such as user.home.
 *
 * @see Resources
 * @version $Id: TryProp.java,v 3.1 2000/08/28 09:25:52 lefevre Exp $
 * @author  Jean-Paul Le Fvre
 */

class TryProp extends TryProg {
    /**
     * @serial the name of the properties file.
     */
private	String	filename = null;

//______________________________________________________________________________
    /**
     * Runs the program. Resources are loaded then dumped.
     * <Br>
     * The directory where the properties file is located can
     * be set on the command line.
     */
public static void main (String args[])
  {
    TryProp prog = new TryProp("TryProp");

    if (! prog.parseArg(args)) {
      System.err.println("Can't parse command line !");
      return;
    }

    prog.run();
  }
//______________________________________________________________________________

public TryProp(String name)
  {
    super(name);
  }
//______________________________________________________________________________
    /**
     * Executes the program.
     */
public	void run()
  {
      Resources resources = Resources.instance();
      resources.load(filename);
      resources.copyFromSystem("Def.On.Line");

      dump();
  }
//______________________________________________________________________________
  /**
   * Dumps the set of resources.
   * <Br>
   * The system properties are first printed, then the jvs ones.
   *
   * @see Properties#list
   * @see Resources#dump
   */
public void dump()
  {
      try {
	  Properties prop  = System.getProperties();
	  ToolBox.warn("Dumping system resources");
	  prop.list(System.out);
      }
      catch(SecurityException ex) {
	  ToolBox.warn("Can't dump system resources", ex);
      }

      System.out.println();

      try {
	  ToolBox.warn("JVS Home : " + Resources.instance().getJVSHome());
	  Resources.instance().dump();
      }
      catch(SecurityException ex) {
	  ToolBox.warn("Can't dump JVS resources", ex);
      }
  }
//______________________________________________________________________________
    /**
     * Parses the command line.
     * Usage   : -v|d filename
     */
public	boolean parseArg(String args[])
  {
    int i     = 0;
    int error = 0;

    while(i < args.length && args[i].startsWith("-")) {

      String arg = args[i++];
      int j;

      for (j = 1; j < arg.length(); j++) {

	char flag = arg.charAt(j);

	switch (flag) {
	case 'v':
	  ToolBox.verbose = true;
	  ToolBox.debug   = false;
	  break;

	case 'd':
	  ToolBox.verbose = true;
	  ToolBox.debug   = true;
	  break;
	}
      }
    }

    if(i < args.length)
      filename = args[i];

    return (error == 0);
  }
//______________________________________________________________________________
}


