//______________________________________________________________________________

//	Java Test program
//______________________________________________________________________________

package org.ariane.test;

import org.ariane.tools.*;
import org.ariane.time.Calendar;

/**
 * TryMonth : a test program for Calendar.
 *
 * @see Calendar#moveMonth
 * @version $Id: TryMonth.java,v 3.0 2000/08/23 13:15:34 lefevre Exp $
 * @author  Jean-Paul Le Fvre
 */

class TryMonth extends TryProg {
  /**
   * @serial Toward the future or back in the past.
   */
private	boolean	forward = true;
  /**
   * @serial Number of iterations.
   */
private	int	nbr = 3;
  /**
   * @serial Day of the month.
   */
private	int	day;

//______________________________________________________________________________

public static void main (String args[])
  {

    TryMonth prog = new TryMonth("TryMonth");

    if (! prog.parseArg(args)) {
      System.err.println("Can't parse command line !");
      return;
    }

    if (! prog.run()) {
      System.err.println("Can't execute TryMonth !");
      return;
    }

  }
//______________________________________________________________________________

public TryMonth(String name)
  {
    super(name);
    Calendar cal = new Calendar();
    cal.setTimeZone(Calendar.UTC);
    day          = cal.get(Calendar.DAY_OF_MONTH);
    cal.printFields();
  }
//______________________________________________________________________________

public	boolean run()
  {
    if(ToolBox.verbose) System.out.println("Running TryMonth ...");

    Calendar cal = new Calendar();
    cal.setTimeZone(Calendar.UTC);
    cal.fixFields();

    cal.set(Calendar.DAY_OF_MONTH, day);
    cal.set(Calendar.AM_PM,  	   Calendar.AM);
    cal.set(Calendar.HOUR_OF_DAY,  0);
    cal.set(Calendar.HOUR,  	   0);
    cal.set(Calendar.MINUTE,      10);
    cal.set(Calendar.SECOND,       0);
    cal.set(Calendar.MILLISECOND,  0);
    cal.fixFields();

    cal.printFields();

    if(Calendar.UTC.useDaylightTime())
	System.out.println("Next with dst...\n");
    else
	System.out.println("Next without dst ...\n");

    for(int i = 0; i < nbr; i++) {

	cal.moveMonth(forward);
	cal.printFields();
    }

    return true;
  }
//______________________________________________________________________________
  /**
   * Parses the command line.
   * Usage   : -v -f|-b -n nbr -d day
   */
public	boolean parseArg(String args[])
  {
    int i     = 0;
    int error = 0;

    while(i < args.length && args[i].startsWith("-")) {

      String arg = args[i++];
      int j;

      for (j = 1; j < arg.length(); j++) {

	char flag = arg.charAt(j);

	switch (flag) {
	case 'f':
	  forward = true;
	  break;

	case 'b':
	  forward = false;
	  break;

	case 'n':
	  nbr = Integer.parseInt(args[i++]);
	  break;

	case 'v':
	  ToolBox.verbose = true;
	  break;

	case 'd':
	  day = Integer.parseInt(args[i++]);
	  break;
	}
      }
    }

    return (error == 0);
  }
//______________________________________________________________________________
}

