//______________________________________________________________________________

//	Java Test program
//______________________________________________________________________________

package org.ariane.test;

import org.ariane.tools.*;

/**
 * Tries to see how the memory is managed.
 *
 * @version $Id: TryMemory.java,v 3.0 2000/08/23 13:15:34 lefevre Exp $
 * @author  Jean-Paul Le Fvre
 */

class TryMemory extends TryProg {

    /**
     * @serial the number of objects allocated.
     */
private int number;
    /**
     * @serial the estimated free memory.
     */
private long freemem;
    /**
     * @serial the current runtime object.
     */
private Runtime rt;
    /**
     * @serial the object used to test memory usage.
     */
    private class Sample {
	byte[] s;
	private Sample() {
	    s = new byte[1000];
	    s[0] = 100;
	}
    }
//______________________________________________________________________________

public static void main (String args[])
  {

    TryMemory prog = new TryMemory("TryMemory");

    if (! prog.parseArg(args)) {
      System.err.println("Can't parse command line !");
      return;
    }

    if (! prog.run()) {
      System.err.println("Can't execute TryMemory !");
      return;
    }

  }
//______________________________________________________________________________
    /**
     * Creates an instance of the program.
     * The number of objects is initialised to 0.
     * @param name the name of the program.
     */
public TryMemory(String name)
  {
    super(name);
    number = 0;
    rt     = Runtime.getRuntime();
  }
//______________________________________________________________________________
    /**
     * Executes the programs. It prints the collection of permissions.
     */    
public	boolean run()
  {
    if(ToolBox.verbose)
      System.out.println("Running TryMemory ...");

    try {
	freemem = rt.freeMemory();
	System.out.println("At the beginning : Memory free : " + freemem +
			   " total : " + rt.freeMemory());
	if(number < 1) return true;

	Sample[] set = new Sample[number];
	printInfo("Array of " + number + " entries :");

	for(int i = 0; i < number; i++) {
	    set[i] = new Sample();
	}
	printInfo("Array of " + number + " samples :");

    }
    catch(Exception ex) {
      ToolBox.warn("Something went wrong", ex);
      return false;
    }

    return true;
  }
//______________________________________________________________________________
    /**
     * Prints information about the memory.
     * @param msg a comment to be printed.
     */    
private	void printInfo(String msg)
  {
      System.out.print(msg);
      long fm = rt.freeMemory();
      System.out.println(" memory free : "  + fm +
                               " delta : "  + (freemem - fm));
      freemem = fm;
  }
//______________________________________________________________________________
  /**
   * Parses the command line.
   * Usage   : [-v] -n number
   */
public	boolean parseArg(String args[])
  {
    int i     = 0;
    int error = 0;

    while(i < args.length && args[i].startsWith("-")) {

      String arg = args[i++];
      int j;

      for (j = 1; j < arg.length(); j++) {

	char flag = arg.charAt(j);

	switch (flag) {
	case 'v':
	  ToolBox.verbose = true;
	  break;

	case 'n':
	  number = Integer.parseInt(args[i++]);
	  break;
	}
      }
    }

    return (error == 0);
  }
//______________________________________________________________________________
}

