//______________________________________________________________________________

//	Java Virtual Shelf	- Jean-Paul Le Fvre
//______________________________________________________________________________

package org.ariane.test;

import java.awt.*;
import javax.swing.JLabel;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import org.ariane.applet.WebForm;

/**
 * A test program to see how widgets are draws on a main window.
 *
 * @version $Id: TryLayout.java,v 3.0 2000/08/23 13:15:34 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */

public	class TryLayout extends WebForm  {

//______________________________________________________________________________

public void	init()
  {
    super.init("Laying out widgets");
    final int space = 2;
    Border border   = BorderFactory.createLineBorder(Color.red);

    JLabel widget;
    //						Communication widgets
    widget	   = new JLabel("1-1");
    cons.gridwidth = 1;
    cons.insets    = new Insets(space, space, space, space);
    grid.setConstraints(widget, cons);
    widget.setBackground(Color.yellow);
    widget.setBorder(border);
    widget.setOpaque(true);
    widget.setVerticalAlignment(JLabel.BOTTOM);
    widget.setHorizontalAlignment(JLabel.LEFT);
    add(widget);

    widget	   = new JLabel("1-2");
    grid.setConstraints(widget, cons);
    widget.setBackground(Color.yellow);
    widget.setBackground(Color.yellow);
    widget.setBorder(border);
    widget.setOpaque(false);
    widget.setVerticalAlignment(JLabel.CENTER);
    widget.setHorizontalAlignment(JLabel.CENTER);
    add(widget);

    widget	   = new JLabel("1-3");
    cons.gridwidth = GridBagConstraints.REMAINDER;
    grid.setConstraints(widget, cons);
    widget.setBackground(Color.yellow);
    widget.setBorder(border);
    widget.setOpaque(true);
    widget.setVerticalAlignment(JLabel.BOTTOM);
    widget.setHorizontalAlignment(JLabel.RIGHT);
    add(widget);

    widget	   = new JLabel("2-1");
    cons.gridwidth = 1;
    grid.setConstraints(widget, cons);
    widget.setBackground(Color.yellow);
    widget.setBorder(border);
    widget.setOpaque(true);
    widget.setVerticalAlignment(JLabel.TOP);
    widget.setHorizontalAlignment(JLabel.LEFT);
    add(widget);

    widget	   = new JLabel("2-2");
    cons.gridwidth = GridBagConstraints.REMAINDER;
    grid.setConstraints(widget, cons);
    widget.setBackground(Color.yellow);
    widget.setBorder(border);
    widget.setOpaque(true);
    widget.setVerticalAlignment(JLabel.TOP);
    widget.setHorizontalAlignment(JLabel.RIGHT);
    add(widget);

    setSize(400, 300);

  }
//______________________________________________________________________________
}




