//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.test;

import org.ariane.tools.*;

/**
 * A test program for Format.
 *
 * @version $Id: TryFormat.java,v 3.0 2000/08/23 13:15:34 lefevre Exp $
 * @author  Jean-Paul Le Fvre
 * @see RealNumber
 * @see FxpN
 * @see FlpN
 */

class TryFormat extends TryProg {
  /**
   * @serial the numbers to process.
   */
private	RealNumber[] numbers;

//______________________________________________________________________________

public static void main (String args[])
  {

    TryFormat prog = new TryFormat("TryFormat");

    if (! prog.parseArg(args)) {
      System.err.println("Can't parse command line !");
      exitWrong();
    }

    if (! prog.run()) {
      System.err.println("Can't execute TryFormat !");
      exitWrong();
    }

  }
//______________________________________________________________________________

public TryFormat(String name)
  {
    super(name);
  }
//______________________________________________________________________________

public	boolean run()
  {
      for(int i = 0; i < numbers.length; i++) {
	  System.out.println(numbers[i].toString() + " "
			   + numbers[i].doubleValue());
      }

    return true;
  }
//______________________________________________________________________________
    /**
     * Parses the command line.
     * Usage   : -v|d number1 number2 .... 
     */
public	boolean parseArg(String args[])
  {
    int i     = 0;
    int error = 0;

    while(i < args.length && args[i].startsWith("-")) {

      String arg = args[i++];
      int j;

      for (j = 1; j < arg.length(); j++) {

	char flag = arg.charAt(j);

	switch (flag) {
	case 'v':
	  ToolBox.verbose = true;
	  break;

	case 'd':
	  ToolBox.verbose = true;
	  ToolBox.debug   = true;
	  break;
	}
      }
    }

    if(i >= args.length)
      return false;

    numbers = new RealNumber[args.length - i];

    for(int j = 0; i < args.length; j++) {
	numbers[j] = new FlpN(Double.parseDouble(args[i++]));
    }

   return (error == 0);
  }
//______________________________________________________________________________
}

