//______________________________________________________________________________

//	Java Test program
//______________________________________________________________________________

package org.ariane.test;

import org.ariane.tools.*;

/**
 * A test program for DataSet.
 *
 * @see InputDataset
 * @version $Id: TryFile.java,v 3.0 2000/08/23 13:15:34 lefevre Exp $
 * @author  Jean-Paul Le Fevre
 */

class TryFile extends TryProg {

    /**
     * @serial the name of the file.
     */
private	String	filename;

//______________________________________________________________________________

public static void main (String args[])
  {

    TryFile prog = new TryFile("TryFile");

    if (! prog.parseArg(args)) {
      System.err.println("Can't parse command line !");
      return;
    }

    if (! prog.run()) {
      System.err.println("Can't execute TryFile !");
      return;
    }

  }
//______________________________________________________________________________

public TryFile(String name)
  {
    super(name);
    filename = "";
  }
//______________________________________________________________________________

public	boolean run()
  {
    if(ToolBox.verbose)
      System.err.println("Running TryFile on " + filename + " ...");

    InputDataset file = new InputDataset(filename);
    if(ToolBox.debug)	file.dump();

    try {

      file.open();

      String line;

      while((line = file.getNextLine()) != null) {

	System.out.println(file.lineNumber() + " " + line);

      }

      file.close();
    }
    catch(Exception e) {
      System.err.println("Can't read file " + file.getName() + " !");
      System.out.println("Exception caught : " + e + " !"); 
      return false;
    }

    return true;
  }
//______________________________________________________________________________
/**
 * Purpose : parse the command line.
 * Usage   : -v|d filename
 */
public	boolean parseArg(String args[])
  {
    int i     = 0;
    int error = 0;

    while(i < args.length && args[i].startsWith("-")) {

      String arg = args[i++];
      int j;

      for (j = 1; j < arg.length(); j++) {

	char flag = arg.charAt(j);

	switch (flag) {
	case 'v':
	  ToolBox.verbose = true;
	  break;

	case 'd':
	  ToolBox.verbose = true;
	  ToolBox.debug   = true;
	  break;
	}
      }
    }

    if(i < args.length)
      filename = args[i];
    else
      return false;

    return (error == 0);
  }
//______________________________________________________________________________
}

