//______________________________________________________________________________

//	Java Test program
//______________________________________________________________________________

package org.ariane.test;

import java.io.*;

/**
 * Launches a command from a the virtual machine.
 * <P>
 * Example <Code>:
 * java org.ariane.test.TryExec netscape -remote 'openURL(http://localhost)'
 * </Code>
 * @see Runtime
 */
public class TryExec {

public static void main(String args[])
  {

      StringBuffer buf = new StringBuffer();
      for(int i = 0; i < args.length; i++) {
	  buf.append(args[i]).append(' ');
      }

      System.out.println("cmd : " + buf.toString());
      
      Runtime rt = Runtime.getRuntime();

      try {
	  Process job = rt.exec(args);
	  BufferedReader rd = new BufferedReader(
			      new InputStreamReader(job.getInputStream()));
	  job.waitFor();

	  while(rd.ready()) {
	      String s = rd.readLine();
	      System.out.println(s);
	  }

	  System.out.println("rc : " + job.exitValue());
      }
      catch(Exception ex) {
	  System.out.println("ex : " + ex.getMessage());
      }
  }
//______________________________________________________________________________
}


