//______________________________________________________________________________

//	Java Test program	- Jean-Paul Le Fvre
//______________________________________________________________________________

package org.ariane.test;

import org.ariane.tools.*;
import org.ariane.net.*;
/**
 * Tests the classes Domain and Host.
 *
 * @see NetHost
 * @see NetDomain
 * @version $Id: TryDomain.java,v 3.0 2000/08/23 13:15:34 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */

class TryDomain extends TryProg {

    /**
     * @serial the domain tested.
     */
private	NetDomain 	domain = null;
    /**
     * @serial the host tested.
     */
private	NetHost 	host   = null;

public static void main (String args[])
  {
    TryDomain prog = new TryDomain();

    if (! prog.parseArg(args)) {
      System.err.println("Can't parse command line !");
      return;
    }

    prog.run();
  }
//______________________________________________________________________________

public TryDomain()
  {
    super("TryDomain");
  }
//______________________________________________________________________________

public void run()
  {
      if(domain == null) domain = OurDomain.instance();

      if(ToolBox.debug) ToolBox.warn(domain.toString());

      if(host == null) host = new NetHost();

      if(host.isInDomain(domain)) {
	  ToolBox.warn(host.getName() + " is in " + domain.getName());
      }
      else {
	  ToolBox.warn(host.getName() + " is not in " + domain.getName());
      }
  }
//______________________________________________________________________________
    /**
     * Parses the command line.
     * Usage   : [-v|d] [-h host] [n1 n2 ...]
     */
public	boolean parseArg(String args[])
  {
    int i     = 0;
    int error = 0;

    while(i < args.length && args[i].startsWith("-")) {

      String arg = args[i++];
      int j;

      for (j = 1; j < arg.length(); j++) {

	char flag = arg.charAt(j);

	switch (flag) {
	case 'v':
	  ToolBox.verbose = true;
	  break;

	case 'd':
	  ToolBox.verbose = true;
	  ToolBox.debug   = true;
	  break;

	case 'h':
	  host = new NetHost(args[i++]);
	  break;

	default :
	  error++;
	}
      }
    }

    if(i < args.length) {

      domain	    = new NetDomain("unknown");
      String[] nets = new String[args.length - i];

      for(int j = 0; j < nets.length; j++) {
	  nets[j] = args[i++];
      }
      domain.define(nets);
    }

    return (error == 0);
  }
//______________________________________________________________________________
}


