//______________________________________________________________________________

//	Java Test program
//______________________________________________________________________________

package org.ariane.test;

import org.ariane.tools.*;
import org.ariane.time.Calendar;

/**
 * A test program for Calendar.
 *
 * @see Calendar#setToWeekDay
 * @version $Id: TryDay.java,v 3.0 2000/08/23 13:15:34 lefevre Exp $
 * @author  Jean-Paul Le Fvre
 */

class TryDay extends TryProg {
  /**
   * @serial Toward the future or back in the past.
   */
private	boolean	forward = true;
  /**
   * @serial Number of iterations.
   */
private	int	nbr = 3;
  /**
   * @serial Day of the week.
   */
private	int	day;

//______________________________________________________________________________

public static void main (String args[])
  {

    TryDay prog = new TryDay("TryDay");

    if (! prog.parseArg(args)) {
      System.err.println("Can't parse command line !");
      return;
    }

    if (! prog.run()) {
      System.err.println("Can't execute TryDay !");
      return;
    }

  }
//______________________________________________________________________________

public TryDay(String name)
  {
    super(name);
    Calendar cal = new Calendar();
    day          = cal.get(Calendar.DAY_OF_WEEK);

  }
//______________________________________________________________________________

public	boolean run()
  {
    if(ToolBox.verbose)
      System.out.println("Running TryDay ...");

    Calendar cal = new Calendar();

    for(int i = 0; i < nbr; i++) {

	cal.setToWeekDay(day, forward);
	System.out.println(cal.toString());
    }

    return true;
  }
//______________________________________________________________________________
  /**
   * Parses the command line.
   * <br>
   * Usage   : -v -f|-b -n nbr -d day
   */
public	boolean parseArg(String args[])
  {
    int i     = 0;
    int error = 0;

    while(i < args.length && args[i].startsWith("-")) {

      String arg = args[i++];
      int j;

      for (j = 1; j < arg.length(); j++) {

	char flag = arg.charAt(j);

	switch (flag) {
	case 'f':
	  forward = true;
	  break;

	case 'b':
	  forward = false;
	  break;

	case 'n':
	  nbr = Integer.parseInt(args[i++]);
	  break;

	case 'v':
	  ToolBox.verbose = true;
	  break;

	case 'd':
	  day = Integer.parseInt(args[i++]);
	  break;
	}
      }
    }

    return (error == 0);
  }
//______________________________________________________________________________
}

