//______________________________________________________________________________

//	Java Test program
//______________________________________________________________________________

package org.ariane.test;

import java.util.TimeZone;
import java.util.SimpleTimeZone;
import java.util.Date;
import java.text.DateFormat;
import org.ariane.tools.ToolBox;
import org.ariane.time.Calendar;

/**
 * Test program for Class Date.
 *
 * @see Date
 * @see Calendar
 * @author Jean-Paul Le Fvre
 * @version $Id: TryDate.java,v 3.0 2000/08/23 13:15:34 lefevre Exp $
 */

class TryDate {

public static void main (String args[])
  {

    String[] tzid = TimeZone.getAvailableIDs();

    for(int i = 0; i < tzid.length; i++) {
	TimeZone tz = TimeZone.getTimeZone(tzid[i]);
	int offset  = tz.getRawOffset();
	String dst  = tz.useDaylightTime() ? "DST" : " - ";
	System.out.println(tzid[i] + " d : " + offset + " " + dst);
    }

    Date d = new Date();
    System.out.println(d.toString());

    TimeZone tz = new SimpleTimeZone(2 * 60 * 60 * 1000, "GMT");
    int offset  = tz.getRawOffset();
    String dst  = tz.useDaylightTime() ? "DST" : " - ";
    System.out.println("GMT+2 d : " + offset + " " + dst);

    TimeZone.setDefault(tz);
    System.out.println(d.toString());

    DateFormat fmt = DateFormat.getInstance();
    System.out.println(fmt.format(d));

    fmt.setTimeZone(tz);
    System.out.println(fmt.format(d));

    tz = TimeZone.getTimeZone("GMT");
    fmt.setTimeZone(tz);
    System.out.println(fmt.format(d));
  }
//______________________________________________________________________________

}


