//______________________________________________________________________________

//	Java Test program
//______________________________________________________________________________

package org.ariane.test;

import java.util.TimeZone;
import java.util.Date;
import java.text.SimpleDateFormat;
import java.text.ParseException;
import org.ariane.tools.ToolBox;
import org.ariane.time.Calendar;

/**
 * Test program for Class Calendar.
 *
 * @see Calendar
 * @author Jean-Paul Le Fvre
 * @version $Id: TryCalendar.java,v 3.0 2000/08/23 13:15:34 lefevre Exp $
 */

class TryCalendar {

public static void main (String args[])
  {
    Date date = new Date();
    SimpleDateFormat fmt = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    fmt.setTimeZone(Calendar.LTZ);

    if(args.length > 0) {
	try {
	    date = fmt.parse(args[0].trim());
	}
	catch(ParseException ex)  {
	    ToolBox.warn("Can't parse " + args[0], ex);
	    System.exit(1);
	}    
    }

    System.out.print(fmt.format(date) + " ");
    System.out.println(date.toString());

    Calendar cal = new Calendar();
    cal.setCurrentTime(date);
    cal.printFields();

    //    cal.CheckFields();
    cal.set(Calendar.MILLISECOND, 333);
    cal.set(Calendar.SECOND, 33);
    cal.set(Calendar.MINUTE, 33);

    date = cal.getCurrentTime();
    System.out.print(fmt.format(date) + " ");
    System.out.println(date.toString());
    cal.printFields();

  }
//______________________________________________________________________________

}


