//______________________________________________________________________________

//	Java Test program	- Jean-Paul Le Fevre
//	$Id: Test.java,v 3.0 2000/08/23 13:15:34 lefevre Exp $
//______________________________________________________________________________

package org.ariane.test;

import org.ariane.tools.*;
/**
 * Tests simple statements.
 * @see Nobject
 * @version $Id: Test.java,v 3.0 2000/08/23 13:15:34 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */

class Test {

public static boolean verbose	= false;
public static boolean debug	= false;

public static void main (String args[])
  {

    if (! parseArg(args)) {
      System.err.println("Can't parse command line !");
      return;
    }

    whoAmI();

    String name = "object";

    Nobject nobj = new Nobject(name);
    System.out.println(nobj.toString());
  }
//______________________________________________________________________________
  /**
   * Purpose : parse the command line.
   */
private	static	boolean parseArg(String args[])
  {
    int i     = 0;
    int error = 0;

    while(i < args.length && args[i].startsWith("-")) {

      String arg = args[i++];
      int j;

      for (j = 1; j < arg.length(); j++) {

	char flag = arg.charAt(j);

	switch (flag) {
	case 'v':
	  verbose = true;
	  break;

	case 'd':
	  verbose = true;
	  debug = true;
	  break;

	default:
	  error++;
	  System.err.println("ParseArg : illegal option " + flag);
	  break;
	}
      }
    }
    if (i >= args.length)
            error++;

    return (error == 0);
  }
//______________________________________________________________________________

public	static	void whoAmI()
  {
    String name;
    name = System.getProperty("user.name");
    System.out.print("Hi ");
    System.out.print(name);
    System.out.println(" !");
  }
}
//______________________________________________________________________________

