//______________________________________________________________________________

//	Java Test program
//______________________________________________________________________________

package org.ariane.test;

import java.security.*;
import java.security.cert.Certificate;
import java.net.URL;
import org.ariane.tools.*;
import org.ariane.security.Controller;

/**
 * Dumps the set of permissions.
 * <Br>
 * <Code>Usage : org.ariane.test.ShowPerm [-vd][-u user][codesource]</Code>
 * <Br>
 * If the code source is not specified <Code>jvs.home/jvs.jar</Code> is
 * used.
 *
 * @version $Id: ShowPerm.java,v 3.0 2000/08/23 13:15:34 lefevre Exp $
 * @author  Jean-Paul Le Fvre
 */

class ShowPerm extends TryProg {

    /**
     * @serial The url of the code source.
     */
private	String location = null;

    /**
     * @serial user name.
     */
private	String user = null;

//______________________________________________________________________________

public static void main (String args[])
  {

    ShowPerm prog = new ShowPerm("ShowPerm");

    if (! prog.parseArg(args)) {
      System.err.println("Can't parse command line !");
      return;
    }

    if (! prog.run()) {
      System.err.println("Can't execute ShowPerm !");
      return;
    }

  }
//______________________________________________________________________________

public ShowPerm(String name)
  {
    super(name);
  }
//______________________________________________________________________________
    /**
     * Executes the programs. It prints the collection of permissions.
     * @see PermissionCollection
     */    
public	boolean run()
  {
    if(ToolBox.verbose)
      System.out.println("Running ShowPerm ...");

    try {
      Policy policy  = Policy.getPolicy();
      CodeSource src = getCodeSource();

      PermissionCollection permcol = policy.getPermissions(src);

      System.out.println("Code source : " + src.toString()
		       + " user : " + String.valueOf(user));
      System.out.println();
      System.out.println(permcol.toString());
    }
    catch(Exception ex) {
      ToolBox.warn("Can't dump permissions", ex);
      return false;
    }

    return true;
  }
//______________________________________________________________________________
  /**
   * Returns the code source.
   * <Br>
   * If the location is not given on the command line, the content
   * of <Code>jvs.home</Code> is taken. If this property is not
   * defined a default value is used. The certificate is used if
   * a user is specified.
   *
   * @return the code source.
   * @see CodeSource
   * @see Controller#getCertificate
   */
public	CodeSource getCodeSource()
  {
    CodeSource source = null;

    if(location == null) {
	location = resources.get("jvs.home");
	if(location != null) {
	    location = "file://" + location + "/jvs.jar";
	}
	else {
	    location = "file:///home/lefevre/soft/Java/src";
	}
    }

    try {
	Certificate[] certif;
	if(user != null) {
	    Controller ctrl = new Controller();
	    certif    = new Certificate[1];
	    certif[0] = ctrl.getCertificate(user);
	}
	else {
	   certif = null;
	}

	URL url   = new URL(location);
	source    = new CodeSource(url, certif);
    }
    catch(Exception ex) {
      ToolBox.warn("Can't create code source", ex);
    }

    return source;
  }
//______________________________________________________________________________
  /**
   * Parses the command line.
   * <Br>
   * Usage   : [-v] [-u username] [codesource]
   */
public	boolean parseArg(String args[])
  {
    int i     = 0;
    int error = 0;

    while(i < args.length && args[i].startsWith("-")) {

      String arg = args[i++];
      int j;

      for (j = 1; j < arg.length(); j++) {

	char flag = arg.charAt(j);

	switch (flag) {
	case 'v':
	  ToolBox.verbose = true;
	  break;

	case 'd':
	  ToolBox.verbose = true;
	  ToolBox.debug   = true;
	  break;

	case 'u':
	  user = args[i++];
	  break;

	}
      }
    }

    if(i < args.length)
	location = args[i++];

    return (error == 0);
  }
//______________________________________________________________________________
}

