//______________________________________________________________________________

//	Java Test program
//______________________________________________________________________________

package org.ariane.test;

import org.ariane.tools.*;

import java.util.Date;
import java.util.Locale;
import java.text.DateFormat;
import java.io.*;

/**
 * Examines the behaviour of the JVS under different localization..
 * <Br>
 * <Code>Usage : org.ariane.test.ShowLocale [-vd] [locate_ident]</Code>
 * <Br>
 * If an ident is not specified on the command line, the default locale
 * is used. The ident is made of 2 (possibly 3) tokens separated by
 * underscore : language_country_variant.
 *
 * @see Locale
 * @see TryFormat
 * @version $Id: ShowLocale.java,v 3.0 2000/08/23 13:15:34 lefevre Exp $
 * @author  Jean-Paul Le Fvre
 */

class ShowLocale extends TryProg {

    /**
     * @serial The locale ident.
     */
private	String ident = null;

//______________________________________________________________________________

public static void main (String args[])
  {

    ShowLocale prog = new ShowLocale("ShowLocale");

    if (! prog.parseArg(args)) {
      System.err.println("Can't parse command line !");
      return;
    }

    if (! prog.run()) {
      System.err.println("Can't execute ShowLocale !");
      return;
    }
  }
//______________________________________________________________________________

public ShowLocale(String name)
  {
    super(name);
  }
//______________________________________________________________________________
    /**
     * Executes the programs. It dumps the locale.
     * @see Locale
     */    
public	boolean run()
  {
    if(ToolBox.verbose)
      System.out.println("Running ShowLocale ...");

    if(ToolBox.debug) {
	Locale[] list = Locale.getAvailableLocales();
	System.out.println("Avalaible locales :");
	for(int i = 0; i < list.length; i++) {
	    System.out.println(list[i].getDisplayName());
	}
	System.out.println();
    }

    Locale locale = ToolBox.setLocale(ident);

    System.out.println("Locale : " + locale.getDisplayName());

    final double nbr = 1234567.8912; // a sample
    final Double Nbr = new Double(nbr);
    final FxpN  fxn  = new FxpN(nbr);

    System.out.println("double : " + nbr);
    System.out.println("Double : " + Nbr);
    System.out.println("FxpN   : " + fxn);

    DateFormat fmt = DateFormat.getDateInstance();
    System.out.println("Date   : " + fmt.format(new Date()));

    BufferedReader d = new BufferedReader(new InputStreamReader(System.in));
    System.out.print("\nHit keys like a z ... ! ");
    try {
	String keys = d.readLine();
	System.out.println("Keys   : " + keys);
    }
    catch(IOException ex) {
	      System.out.println("Can't read keys !");
    }

    return true;
  }
//______________________________________________________________________________
  /**
   * Parses the command line.
   * <Br>
   * Usage   : [-vd] locale_ident
   */
public	boolean parseArg(String args[])
  {
    int i     = 0;
    int error = 0;

    while(i < args.length && args[i].startsWith("-")) {

      String arg = args[i++];
      int j;

      for (j = 1; j < arg.length(); j++) {

	char flag = arg.charAt(j);

	switch (flag) {
	case 'v':
	  ToolBox.verbose = true;
	  ToolBox.debug   = false;
	  break;

	case 'd':
	  ToolBox.verbose = true;
	  ToolBox.debug   = true;
	  break;
	}
      }
    }

    if(i < args.length)
      ident = args[i];

    return (error == 0);
  }
//______________________________________________________________________________
}

