//______________________________________________________________________________

//	Java Test program
//______________________________________________________________________________

package org.ariane.test;

/**
 * Gives the version of the current java installation.
 * <p>
 * Usage : java org.ariane.test.JavaVersion [-d]
 * <p>
 * It prints integer 'nmo' if version is string 'n.m.o'
 * @version $Id: JavaVersion.java,v 1.2 2000/10/02 09:46:53 lefevre Exp $
 * @author  Jean-Paul Le Fvre
 * @see TryProp
 */

class JavaVersion {
    /**
     * Prints the java version number.
     */
public static void main (String args[])
{
    boolean debug = false;

    if(args.length > 0 && args[0].equals("-d")) {
	debug = true;
	printVersion("java.vm.version");
	printVersion("java.runtime.version");
	printVersion("java.fullversion");
	printVersion("java.class.version");
	printVersion("java.specification.version");
	printVersion("java.vm.specification.version");
	printVersion("java.version");
    }

    int version = 0;
    try {
	String string   = System.getProperty("java.version");
        final int radix = 10;

	int digit = Character.digit(string.charAt(0), radix);
	if(digit > 0) version  = 100 * digit;

	digit = Character.digit(string.charAt(2), radix);
	if(digit > 0) version +=  10 * digit;

	digit = Character.digit(string.charAt(4), radix);
	if(digit > 0) version +=       digit;

	System.out.println(version);
	System.exit(0);
    }
    catch(Exception ex) {
	System.out.println(version);
	if(debug) ex.printStackTrace();
	System.exit(1);
    }
}
//______________________________________________________________________________
/**
 * Prints a specific version.
 * <Br>
 * @param object the name of the property giving the version.
 * @see	System#getProperty
 */
static private void printVersion(String object)
  {
      try {
	  String version = System.getProperty(object);
	  System.out.println(object + " : " + String.valueOf(version));
      }
      catch(Exception ex) {
	  System.out.println("Can't get value of " + object);
	  ex.printStackTrace();
      }
  }
//______________________________________________________________________________
}

