//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package	org.ariane.stats;

/**
 * ValueCount : a class managing a counted value.
 *
 * @version $Id: ValueCount.java,v 3.0 2000/08/23 13:15:34 lefevre Exp $
 * @author  Jean-Paul Le F&egrave;vre
 */
public	class ValueCount extends ObjectCount {

//______________________________________________________________________________
  /**
   * Initialisation to : 0 and 0.
   */
public ValueCount()
{
    super(new Integer(0), 0);
}
//______________________________________________________________________________
  /**
   * Initialisation
   * @param v the value.
   * @param c the count.
   */
public ValueCount(int v, int c)
{
    super(new Integer(v), c);
}
//______________________________________________________________________________
/**
 * Initialisation
 * @param v the value.
 */
public ValueCount(int v)
{
    super(new Integer(v), 0);
}
//______________________________________________________________________________
/**
 * Compares this ValueCount to another specified ValueCount.
 * Returns an integer that is less than, equal
 * to, or greater than zero. The integer's value depends on whether
 * the value is less than, equal to, or greater the value of the
 * other ValueCount.
 * @param other the object to compare to.
 */
public int compareTo(ValueCount other)
{
    int i = value();
    int j = other.value();

    return i == j ? 0 : (i > j ? -1 : +1);
}
//______________________________________________________________________________
/**
 * Returns the value.
 * @return the value;
 */
final public int value()
{
    return ((Integer)object).intValue();
}
//______________________________________________________________________________
}




