//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package	org.ariane.stats;

/**
 * ObjectCount : a class managing the count for an object.
 *
 * @see Object
 * @version $Id: ObjectCount.java,v 3.0 2000/08/23 13:15:34 lefevre Exp $
 * @author  Jean-Paul Le F&egrave;vre
 */
public	class ObjectCount extends Object implements Countable {

  /**
   * @serial the current count.
   */
protected int count;
  /**
   * @serial the observed object.
   */
protected Object object;

//______________________________________________________________________________
  /**
   * Initialisation.
   */
public ObjectCount()
  {
      this(null, 0);
  }
//______________________________________________________________________________
  /**
   * Initialisation
   * @param obj the object.
   * @param c the count.
   */
public ObjectCount(Object obj, int c)
  {
    count  = c;
    object = obj;
  }
//______________________________________________________________________________
  /**
   * Builds the line : 'object : count'
   * @return the string.
   */
public String toString()
  {
    return object.toString() + " : " + count;
  }
//______________________________________________________________________________
  /**
   * Returns the current count.
   */
final public int getCount()
  {
    return count;
  }
//______________________________________________________________________________
  /**
   * Sets the current count.
   * @param c the value.
   */
final public void setCount(int c)
  {
    count = c;
  }
//______________________________________________________________________________
  /**
   * Increments the count.
   */
final public void increment()
  {
    count++;
  }
//______________________________________________________________________________
  /**
   * Returns a reference to the current object.
   */
final public Object getObject()
  {
    return object;
  }
//______________________________________________________________________________
  /**
   * Compares two ObjectCounts for equality.
   * Returns a boolean that indicates whether this Object is equivalent 
   * to the specified Object. This method is used when an Object is stored
   * in a set. Compare only the objects.
   * @param	other	the Object to compare with
   * @return	true if these Objects are equal; false otherwise.
   */
public boolean equals(Object other)
{	
    if ((other != null) && (other instanceof ObjectCount))
	return object.equals(((ObjectCount)other).object);
    return false;
}
//______________________________________________________________________________
}




