//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.stats;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.ariane.tools.ToolBox;
import org.ariane.tools.Nobject;

/** 
 * CountSet : a container for countable objects.
 * <br>
 * The implementation is based on the Vector's one.
 *
 * @version $Id: CountSet.java,v 3.0 2000/08/23 13:15:34 lefevre Exp $
 * @author Jean-Paul Le F&egrave;vre
 * @see	Vector
 * @see	Countable
 */
public	class CountSet extends Nobject {

  /**
   * @serial the array storing the elements.
   */
  Vector 	table;

//______________________________________________________________________________
  /**
   * Creates a Set named 'str'.
   * The size of the the buffer is doubled everytime it needs to grow
   * @see Nobject
   */
public CountSet(String str)
  {
   super(str);
   table = new Vector(50, 0);
  }
//______________________________________________________________________________
  /**
   * Returns an iterator to iterate on the set.
   * @return the iterator.
   */
public final synchronized Iterator iterator()
{
  return table.iterator();
}
//______________________________________________________________________________
  /**
   * Minimizes used memory.
   * @see Vector#trimToSize()
   */
public final synchronized void trimToSize()
  {
    table.trimToSize();
  }
//______________________________________________________________________________
  /**
   * returns the number of elements in the set.
   * @see	Vector#size
   * @return the number of elements in the set.
   */
public final int size()
  {
    return table.size();
  }
//______________________________________________________________________________
  /**
   * Adds a Countable element to the set.
   * @see Vector#addElement
   */
public final void add(Countable obj)
  {
    table.addElement(obj);
  }
//______________________________________________________________________________
  /**
   * Retrieves the element at position 'index' in the set.
   * @param  index the position.
   * @return a reference to the element.
   * @see Vector#elementAt
   */
public final Countable	get(int index)
  {
    return (Countable)table.elementAt(index);
  }
//______________________________________________________________________________
  /**
   * Retrieves the first element in the set.
   * @return a reference to the element.
   * @see Vector#elementAt
   */
public final Countable getFirst()
  {
    return (Countable)table.elementAt(0);
  }
//______________________________________________________________________________
  /**
   * Retrieves the last element in the set.
   * @return a reference to the element.
   * @see Vector#elementAt
   */
public final Countable getLast()
  {
    return (Countable)table.elementAt(table.size() - 1);
  }
//______________________________________________________________________________
/**
 * Computes the total number of samples.
 * @return the value.
 */
public final int totalCount()
{
    int total = 0;
    Iterator e;

    for (e = table.iterator(); e.hasNext() ;)
	total += ((Countable)e.next()).getCount();

    return total;
}
//______________________________________________________________________________
  /**
   * Gets the maximum count value
   * @return the value.
   */
public int maxCount()
  {
    return maxCount(0, table.size());
  }
//______________________________________________________________________________
  /**
   * Gets the maximum count value in the interval [first, last[
   * @return the value.
   */
public int maxCount(int first, int last)
  {
    Iterator e;
    int max = 0;
    int i   = 0;

    for (e = table.iterator(); e.hasNext() ; i++) {

	if(i < first) continue;
	else if(i >= last) break;

	int n = ((Countable)e.next()).getCount();
	if(n > max) max = n;
    }

    return max;
  }
//______________________________________________________________________________
  /**
   * Prints the content of the set on stdout.
   */
public void dump()
  {

    System.out.println(
    "CountSet : " + getName() + " size : " + table.size()
     + " (" + table.capacity() + ") objects !");

    Iterator e;
    long total = 0;

    for (e = table.iterator(); e.hasNext() ;) {
      Countable n = (Countable)e.next();
      total += n.getCount();
      if(ToolBox.debug)	System.out.println(n);
    }

    System.out.println("CountSet : " + getName() + " total : " + total);
    System.out.println();
  }
//______________________________________________________________________________
}




