//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.net;

/** 
 * WebSite : a object describing a web site in the internet.
 * @see FtpSite
 * @version $Id: WebSite.java,v 3.0 2000/08/23 13:15:33 lefevre Exp $
 * @author Jean-Paul Le Fvre
 */
public class WebSite extends NetSite {

//______________________________________________________________________________
/**
 * Creates a WebSite named 'sitename'.
 * @parameter sitename the name for this site.
 * @parameter fqdn the domain name where the site is located.
 * @exception IllegalArgumentException if an argument is null.
 */
public WebSite(String sitename, String fqdn) throws IllegalArgumentException
  {
      super(sitename, fqdn);
  }
//______________________________________________________________________________
/**
 * Returns the string http://fqdn.
 * @return the url.
 */
public String	getURLString()
  {
    return "http://" + getFQDN();
  }
//______________________________________________________________________________
}




