//______________________________________________________________________________

//	Java Virtual Shelf
//______________________________________________________________________________

package org.ariane.net;

import org.ariane.tools.TryProg;
import org.ariane.tools.ToolBox;
import org.ariane.net.HostTag;
import org.ariane.net.NetHost;
import org.ariane.net.TagConnection;
import java.net.ServerSocket;
import java.net.Socket;
import java.io.IOException;

/**
 * TagServer : a server providing tags to the internet community.
 * <P>
 * This object belongs to the package. It should be run by the
 * genuine program RunServer.
 *
 * @see RunServer
 * @see HostTag
 * @version $Id: TagServer.java,v 3.0 2000/08/23 13:15:33 lefevre Exp $
 * @author  Jean-Paul Le F&egrave;vre
 */

public class TagServer extends TryProg implements Runnable {
  /*
   * @serial The tag for the server host.
   */
private	HostTag		tag;
  /*
   * @serial The flag indicating that the server is alive and running.
   */
private	boolean alive;
/**
 * @serial The name of the application used to fetch recources.
 */
public static final String APPLI = "TagServer";
  /**
   * @serial The thread.
   */
private	Thread thread = null;
  /**
   * @serial The server socket.
   */
private	ServerSocket socket;

//______________________________________________________________________________
  /**
   * Creates the server. The tag is created for the local host.
   * @see HostTag
   */
public TagServer()
  {
    super("TagServer");
    tag = new HostTag();
    alive = false;
  }
//______________________________________________________________________________
  /**
   * Stops the thread. It closes very brutally the server socket.
   */
public void stop()
{
    try {
	alive = false;
	socket.close();
	if(ToolBox.verbose) ToolBox.warn("TagServer dead");
    }
    catch(IOException ex) {
	ToolBox.warn("Can't close socket " + APPLI, ex);
    }
}
//______________________________________________________________________________
  /**
   * Starts the thread. Creates the server socket.
   * @see Thread
   * @see ServerSocket
   */
public void start()
{
    int port = resources.get(APPLI + ".Port", 1333);
    if(port < 0) {
	ToolBox.warn("Can't find port number");
	return;
    }

    try {
	socket = new ServerSocket(port);
	alive  = true;
	thread = new Thread(this, APPLI);
	thread.start();
    }
    catch(IOException ex) {
	ToolBox.warn("Can't make socket " + APPLI, ex);
    }
    catch(Exception ex) {
	ToolBox.warn("Can't start " + APPLI, ex);
	thread = null;
    }
}
//______________________________________________________________________________
  /**
   * Executes the thread. Waits for connections.
   * <Br>
   * Spawns off a TagConnection when connected.
   * @see ServerSocket#accept
   * @see TagConnection
   */
public	void run()
{
    if(ToolBox.verbose)
	ToolBox.warn("TagServer " + tag.getHostName() + " "
		     + tag.getIPnumber() + " started");

    try {
	do {
	    Socket client	= socket.accept();
	    TagConnection con	= new TagConnection(this, client, tag);
	    con.start();
	} while(alive);
    }
    catch(IOException ex) {
	ToolBox.warn("Can't accept connection", ex);
    }
    catch(Exception ex) {
	ToolBox.warn("Exception handled", ex);
    }

    if(ToolBox.debug) ToolBox.warn("TagServer terminated");
}
//______________________________________________________________________________
  /**
   * Parses the command line.
   * Usage   : -v|d
   * @see RunServer
   */
public	boolean parseArg(String args[])
  {
    int i     = 0;
    int error = 0;

    while(i < args.length && args[i].startsWith("-")) {

      String arg = args[i++];
      int j;

      for (j = 1; j < arg.length(); j++) {

	char flag = arg.charAt(j);

	switch (flag) {
	case 'v':
	  ToolBox.verbose = true;
	  break;

	case 'd':
	  ToolBox.verbose = true;
	  ToolBox.debug   = true;
	  break;
	}
      }
    }

    return (error == 0);
  }
//______________________________________________________________________________
}

